/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterStationsModule
extends AbstractBuildingModule
implements IBuildingModule,
IPersistentModule,
IBuildingEventsModule {
    private Map<BlockPos, Boolean> buildingToGatherFrom = new HashMap<BlockPos, Boolean>();
    private Random random = new Random();

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.buildingToGatherFrom.clear();
        NBTUtils.streamCompound(compound.getList("buildingstogather", 10)).map(this::deserializeListElement).forEach(t -> this.buildingToGatherFrom.put((BlockPos)t.getA(), (Boolean)t.getB()));
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        compound.put("buildingstogather", (Tag)this.buildingToGatherFrom.entrySet().stream().map(this::serializeListElement).collect(NBTUtils.toListNBT()));
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.buildingToGatherFrom.size());
        for (BlockPos pos : this.buildingToGatherFrom.keySet()) {
            buf.writeBlockPos(pos);
        }
    }

    private Tuple<BlockPos, Boolean> deserializeListElement(CompoundTag nbtTagCompound) {
        BlockPos pos = BlockPosUtil.read(nbtTagCompound, "pos");
        boolean gatheredAlready = nbtTagCompound.getBoolean("gatheredalready");
        return new Tuple((Object)pos, (Object)gatheredAlready);
    }

    private CompoundTag serializeListElement(Map.Entry<BlockPos, Boolean> entry) {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "pos", entry.getKey());
        compound.putBoolean("gatheredalready", entry.getValue().booleanValue());
        return compound;
    }

    public Set<BlockPos> getBuildingsToGatherFrom() {
        return new HashSet<BlockPos>(this.buildingToGatherFrom.keySet());
    }

    @Nullable
    public BlockPos getRandomBuildingToDrainFrom() {
        List buildings = this.buildingToGatherFrom.entrySet().stream().filter(k -> (Boolean)k.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
        if (buildings.isEmpty()) {
            return null;
        }
        return (BlockPos)buildings.get(this.random.nextInt(buildings.size()));
    }

    public void setAsGathered(BlockPos pos) {
        this.buildingToGatherFrom.put(pos, true);
    }

    public void addWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.put(blockPos, false);
        this.markDirty();
    }

    public void removeWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.remove(blockPos);
        this.markDirty();
    }

    @Override
    public void onWakeUp() {
        HashSet<BlockPos> keys = new HashSet<BlockPos>(this.buildingToGatherFrom.keySet());
        this.buildingToGatherFrom.clear();
        keys.forEach(k -> this.buildingToGatherFrom.put((BlockPos)k, false));
    }
}

