/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.IJobWithExternalWorkStations;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.utils.BuilderBucket;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingResourcesModule
extends AbstractBuildingModule
implements IPersistentModule {
    private Map<String, BuildingBuilderResource> neededResources = new LinkedHashMap<String, BuildingBuilderResource>();
    private Deque<BuilderBucket> buckets = new ArrayDeque<BuilderBucket>();
    private int totalStages = 0;
    private int currentStage = 0;

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.currentStage = compound.getInt("currStage");
        this.totalStages = compound.getInt("totalStages");
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        compound.putInt("totalStages", this.totalStages);
        compound.putInt("currStage", this.currentStage);
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        IBuilderWorkOrder workOrder;
        ICitizenData data;
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        double qty = 0.0;
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            Utils.serializeCodecMess(buf, resource.getItemStack());
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
            qty += (double)resource.getAmount();
        }
        Set<ICitizenData> set = this.building.getAllAssignedCitizen();
        ICitizenData iCitizenData = data = set.isEmpty() ? null : set.iterator().next();
        if (data != null && data.getJob() instanceof AbstractJobStructure && (workOrder = ((AbstractBuildingStructureBuilder)this.building).getWorkOrder()) != null) {
            buf.writeInt(workOrder.getID());
            buf.writeDouble(workOrder.getAmountOfResources() == 0 ? 0.0 : qty / (double)workOrder.getAmountOfResources());
            buf.writeInt(this.totalStages);
            buf.writeInt(this.currentStage);
            return;
        }
        buf.writeInt(-1);
        buf.writeDouble(0.0);
        buf.writeInt(0);
        buf.writeInt(0);
    }

    private void updateAvailableResources() {
        ICitizenData data;
        Set<ICitizenData> set = this.building.getAllAssignedCitizen();
        ICitizenData iCitizenData = data = set.isEmpty() ? null : set.iterator().next();
        if (data == null) {
            return;
        }
        data.getEntity().ifPresent(structureBuilder -> {
            InventoryCitizen structureBuilderInventory = data.getInventory();
            if (structureBuilderInventory == null) {
                return;
            }
            for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
                IJob<?> patt0$temp;
                BuildingBuilderResource resource = entry.getValue();
                resource.setAvailable(0);
                if (structureBuilderInventory != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)structureBuilderInventory, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (this.building.getTileEntity() != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler(this.building.getItemHandlerCap(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (!((patt0$temp = data.getJob()) instanceof IJobWithExternalWorkStations)) continue;
                IJobWithExternalWorkStations jobExternalStations = (IJobWithExternalWorkStations)((Object)patt0$temp);
                for (IBuilding station : jobExternalStations.getWorkStations()) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler(station.getItemHandlerCap(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
            }
        });
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    @Nullable
    public BuilderBucket getRequiredResources() {
        return this.buckets.isEmpty() || ((AbstractBuildingStructureBuilder)this.building).getProgress() == null || ((AbstractBuildingStructureBuilder)this.building).getProgress().getB() == BuildingProgressStage.CLEAR ? null : this.buckets.getFirst();
    }

    public BuildingBuilderResource getResourceFromIdentifier(String res) {
        return this.neededResources.get(res);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res) || amount == 0) {
            return;
        }
        int hashCode = res.getComponentsPatch().hashCode();
        String key = res.getDescriptionId() + "-" + hashCode;
        BuildingBuilderResource resource = this.neededResources.get(key);
        if (resource == null) {
            resource = new BuildingBuilderResource(res, amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(key, resource);
        BuilderBucket last = this.buckets.isEmpty() ? null : this.buckets.removeLast();
        int stacks = (int)Math.ceil((double)amount / (double)res.getMaxStackSize());
        int max = this.building.getAllAssignedCitizen().iterator().next().getInventory().getSlots() - 9;
        if (last == null || last.getTotalStacks() >= max || last.getTotalStacks() + stacks >= max) {
            if (last != null) {
                this.buckets.add(last);
            }
            last = new BuilderBucket();
            last.setTotalStacks(stacks);
            last.addOrAdjustResource(key, amount);
            this.buckets.add(last);
        } else {
            int currentQty = last.getResourceMap().getOrDefault(key, 0);
            int currentStacks = (int)Math.ceil((double)currentQty / (double)res.getMaxStackSize());
            int newStacks = (int)Math.ceil((double)(currentQty + amount) / (double)res.getMaxStackSize());
            Map<String, Integer> map = last.getResourceMap();
            last.setTotalStacks(last.getTotalStacks() + newStacks - currentStacks);
            last.addOrAdjustResource(key, currentQty + amount);
            this.buckets.add(last);
        }
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        BuilderBucket last;
        int hashCode = res.getComponentsPatch().hashCode();
        String name = res.getDescriptionId() + "-" + hashCode;
        BuilderBucket builderBucket = last = this.buckets.isEmpty() ? null : this.getRequiredResources();
        if (last != null) {
            Map<String, Integer> map = last.getResourceMap();
            if (map.containsKey(name)) {
                int qty = map.get(name) - amount;
                if (qty > 0) {
                    last.addOrAdjustResource(name, map.get(name) - amount);
                } else {
                    last.removeResources(name);
                }
            }
            if (map.isEmpty()) {
                this.buckets.remove();
            }
        }
        int preAmount = 0;
        if (this.neededResources.containsKey(name)) {
            preAmount = this.neededResources.get(name).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(name);
        } else {
            this.neededResources.get(name).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap<String, BuildingBuilderResource>();
        this.buckets.clear();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        int hashCode = stack.getComponentsPatch().hashCode();
        return this.neededResources.containsKey(stack.getDescriptionId() + "-" + hashCode);
    }

    public void checkOrRequestBucket(@Nullable BuilderBucket requiredResources, ICitizenData worker) {
        if (requiredResources == null) {
            return;
        }
        ImmutableList list = this.building.getOpenRequestsOfType(-1, TypeToken.of(Stack.class));
        HashSet<ItemStorage> requestedItems = new HashSet<ItemStorage>();
        for (IRequest request : list) {
            requestedItems.add(new ItemStorage(((Stack)request.getRequest()).getStack()));
        }
        for (Map.Entry entry : requiredResources.getResourceMap().entrySet()) {
            int count;
            ItemStorage itemStack = this.neededResources.get(entry.getKey());
            if (itemStack == null || (count = InventoryUtils.hasBuildingEnoughElseCount(this.building, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack.getItemStack()), (int)((Integer)entry.getValue()))) >= (Integer)entry.getValue() || (count += InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventory(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack.getItemStack()))) >= (Integer)entry.getValue()) continue;
            int requestCount = (Integer)entry.getValue() - count;
            if (requestedItems.contains(new ItemStorage(itemStack.getItemStack()))) continue;
            this.building.createRequest(new Stack(itemStack.getItemStack(), requestCount * ((AbstractBuildingStructureBuilder)this.building).getResourceBatchMultiplier(), 1), true);
        }
    }

    public void nextStage() {
        if (this.currentStage + 1 > this.totalStages) {
            ++this.totalStages;
        }
        ++this.currentStage;
    }

    public void setTotalStages(int total) {
        this.totalStages = total;
        this.currentStage = 0;
    }

    @Nullable
    public BuilderBucket getNextBucket() {
        Iterator<BuilderBucket> iterator = this.buckets.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

