/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BedHandlingModule
extends AbstractBuildingModule
implements IModuleWithExternalBlocks,
IPersistentModule,
IBuildingEventsModule {
    @NotNull
    private final Set<BlockPos> bedList = new HashSet<BlockPos>();

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        ListTag bedTagList = compound.getList("beds", 11);
        for (int i = 0; i < bedTagList.size(); ++i) {
            this.bedList.add(NBTUtils.readBlockPos(bedTagList.get(i)));
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        if (!this.bedList.isEmpty()) {
            @NotNull ListTag bedTagList = new ListTag();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NBTUtils.writeBlockPos(pos));
            }
            compound.put("beds", (Tag)bedTagList);
        }
    }

    @Override
    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        BlockPos registrationPosition = pos;
        if (blockState.getBlock() instanceof BedBlock) {
            if (blockState.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                registrationPosition = registrationPosition.relative((Direction)blockState.getValue((Property)BedBlock.FACING));
            }
            this.bedList.add(registrationPosition);
        }
    }

    @Override
    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public void onWakeUp() {
        Level world = this.building.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            BlockState state;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((state = world.getBlockState(pos)).getBlock() instanceof BedBlock) || !((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue() || !((BedPart)state.getValue((Property)BedBlock.PART)).equals((Object)BedPart.HEAD)) continue;
            world.setBlock(pos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void removeBed(BlockPos pos) {
        this.bedList.remove(pos);
    }
}

