/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.CitizenDataView;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VisitorDataView
extends CitizenDataView
implements IVisitorViewData {
    private ItemStack recruitmentCosts;
    private volatile ResourceLocation cachedTexture;
    private GameProfile cachedProfile = null;

    public VisitorDataView(int id, IColonyView colony) {
        super(id, colony);
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.recruitmentCosts = Utils.deserializeCodecMess(buf);
        this.recruitmentCosts.setCount(buf.readInt());
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitmentCosts;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        ResourceLocation texture;
        if (this.textureUUID == null) {
            return null;
        }
        if (this.cachedProfile == null) {
            Util.backgroundExecutor().execute(() -> {
                ProfileResult profile;
                if (this.cachedProfile == null && (profile = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(this.textureUUID, true)) != null) {
                    this.cachedProfile = profile.profile();
                }
            });
        }
        if (this.cachedProfile != null && this.cachedTexture == null && (texture = Minecraft.getInstance().getSkinManager().getInsecureSkin(this.cachedProfile).texture()) != DefaultPlayerSkin.get((UUID)this.textureUUID).texture()) {
            this.cachedTexture = texture;
        }
        return this.cachedTexture == null ? DefaultPlayerSkin.get((UUID)this.textureUUID).texture() : this.cachedTexture;
    }
}

