/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.requestsystem.requests.AbstractRequest;
import com.minecolonies.core.colony.requestsystem.requests.StandardRequests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowSelectRequest
extends AbstractModuleWindow<CraftingModuleView> {
    private final Predicate<IRequest<?>> predicate;
    private final Consumer<IRequest<?>> reopenWithRequest;
    private final ScrollingList requestsList;
    private int lifeCount = 0;

    public WindowSelectRequest(CraftingModuleView moduleView, Predicate<IRequest<?>> predicate, Consumer<@Nullable IRequest<?>> reopenWithRequest) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutselectrequest.xml"));
        this.predicate = predicate;
        this.reopenWithRequest = reopenWithRequest;
        this.requestsList = (ScrollingList)this.findPaneOfTypeByID("requests", ScrollingList.class);
        this.registerButton("select", this::select);
        this.registerButton("cancel", this::cancel);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateRequests();
    }

    private List<IRequest<?>> getOpenRequests() {
        ArrayList requests = new ArrayList();
        IRequestManager requestManager = this.buildingView.getColony().getRequestManager();
        IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
        IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
        HashSet requestTokens = new HashSet();
        requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
        requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
        for (IToken iToken : requestTokens) {
            IRequest<?> request = requestManager.getRequestForToken(iToken);
            while (request != null && !requests.contains(request)) {
                if (this.predicate.test(request)) {
                    requests.add(request);
                }
                request = request.hasParent() ? requestManager.getRequestForToken((IToken<?>)request.getParent()) : null;
            }
        }
        return requests;
    }

    private void cancel() {
        this.reopenWithRequest.accept(null);
    }

    private void select(@NotNull Button button) {
        int row = this.requestsList.getListElementIndexByPane((Pane)button);
        List<IRequest<?>> requests = this.getOpenRequests();
        if (row >= 0 && row < requests.size()) {
            this.reopenWithRequest.accept(requests.get(row));
        }
    }

    private void updateRequests() {
        this.requestsList.setDataProvider(new ScrollingList.DataProvider(){
            private List<IRequest<?>> requests = null;

            public int getElementCount() {
                this.requests = WindowSelectRequest.this.getOpenRequests();
                return this.requests.size();
            }

            public void updateElement(int index, Pane rowPane) {
                if (index < 0 || index >= this.requests.size()) {
                    return;
                }
                IRequest<?> request = this.requests.get(index);
                if (request == null) {
                    return;
                }
                ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID("requestStack", ItemIcon.class);
                List<ItemStack> displayStacks = request.getDisplayStacks();
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                if (!displayStacks.isEmpty()) {
                    logo.setVisible(false);
                    exampleStackDisplay.setVisible(true);
                    exampleStackDisplay.setItem(displayStacks.get(WindowSelectRequest.this.lifeCount / 30 % displayStacks.size()));
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(request.getRequester().getRequesterDisplayName(WindowSelectRequest.this.buildingView.getColony().getRequestManager(), request));
                } else {
                    exampleStackDisplay.setVisible(false);
                    if (!request.getDisplayIcon().equals((Object)AbstractRequest.MISSING)) {
                        logo.setVisible(true);
                        logo.setImage(request.getDisplayIcon(), false);
                        PaneBuilders.tooltipBuilder().hoverPane((Pane)logo).build().setText(request.getResolverToolTip(WindowSelectRequest.this.buildingView.getColony()));
                    }
                }
                if (request instanceof StandardRequests.ItemTagRequest) {
                    if (!displayStacks.isEmpty()) {
                        ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(request.getDisplayStacks().get(WindowSelectRequest.this.lifeCount / 30 % displayStacks.size()).getHoverName());
                    }
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(Component.literal((String)request.getShortDisplayString().getString().replace("\u00a7f", "")));
                }
            }
        });
    }
}

