/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.SettingsModuleView;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SettingsModuleWindow
extends AbstractModuleWindow<SettingsModuleView> {
    private final ScrollingList settingsList;

    public SettingsModuleWindow(SettingsModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutsettings.xml"));
        this.settingsList = (ScrollingList)this.window.findPaneOfTypeByID("settingslist", ScrollingList.class);
    }

    public void onOpened() {
        this.updateSettingsList();
    }

    private void updateSettingsList() {
        this.settingsList.enable();
        this.settingsList.show();
        this.settingsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((SettingsModuleView)SettingsModuleWindow.this.moduleView).getSettingsToShow().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ISettingKey<? extends ISetting> key = ((SettingsModuleView)SettingsModuleWindow.this.moduleView).getSettingsToShow().get(index);
                ISetting setting = ((SettingsModuleView)SettingsModuleWindow.this.moduleView).getSetting(key);
                if (setting == null) {
                    return;
                }
                Box box = (Box)rowPane.findPaneOfTypeByID("box", Box.class);
                Text idField = (Text)box.findPaneOfTypeByID("id", Text.class);
                if (idField != null && !idField.getTextAsString().equals(key.getUniqueId().toString())) {
                    box.getChildren().clear();
                }
                if (box.getChildren().isEmpty()) {
                    Loader.createFromXMLFile((ResourceLocation)setting.getLayoutItem(), (View)((View)rowPane));
                    setting.setupHandler(key, rowPane, (ISettingsModuleView)SettingsModuleWindow.this.moduleView, SettingsModuleWindow.this.buildingView, SettingsModuleWindow.this);
                    Text rowIdField = (Text)rowPane.findPaneOfTypeByID("id", Text.class);
                    if (rowIdField != null) {
                        rowIdField.setText(Component.literal((String)key.getUniqueId().toString()));
                    } else {
                        Log.getLogger().warn("Settings for class \"{}\" it's window does not provide an \"id\" field. Make sure this exists so the view can be properly recycled when the settings list is modified!", (Object)setting.getClass().getName());
                    }
                    Text rowDescriptionField = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                    if (rowDescriptionField != null) {
                        rowDescriptionField.setText(Component.translatableEscape((String)("com.minecolonies.coremod.setting." + key.getUniqueId().toString()), (Object[])new Object[0]));
                    }
                }
                setting.render(key, rowPane, (ISettingsModuleView)SettingsModuleWindow.this.moduleView, SettingsModuleWindow.this.buildingView, SettingsModuleWindow.this);
            }
        });
    }
}

