/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.core.client.gui.modules.ItemListModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.ItemListModuleView;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FoodItemListModuleWindow
extends ItemListModuleWindow {
    public FoodItemListModuleWindow(String res, IBuildingView building, IItemListModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/foodlist.xml"));
        this.groupedItemList.removeIf(c -> c.getItemStack().is(ModTags.excludedFood) || !FoodUtils.canEatLevel(c.getItemStack(), building.getBuildingLevel() - 1));
    }

    @Override
    protected void applySorting(List<ItemStorage> displayedList) {
        displayedList.sort((o1, o2) -> {
            int n;
            int n2;
            int score = this.buildingView.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id)).isAllowedItem((ItemStorage)o1) ? 500 : -500;
            int score2 = this.buildingView.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id)).isAllowedItem((ItemStorage)o2) ? 500 : -500;
            Item patt0$temp = o1.getItem();
            if (patt0$temp instanceof IMinecoloniesFoodItem) {
                IMinecoloniesFoodItem foodItem = (IMinecoloniesFoodItem)patt0$temp;
                n2 = foodItem.getTier() * -100;
            } else {
                n2 = -o1.getItemStack().getFoodProperties(null).nutrition();
            }
            score += n2;
            Item patt1$temp = o2.getItem();
            if (patt1$temp instanceof IMinecoloniesFoodItem) {
                IMinecoloniesFoodItem foodItem2 = (IMinecoloniesFoodItem)patt1$temp;
                n = foodItem2.getTier() * -100;
            } else {
                n = -o2.getItemStack().getFoodProperties(null).nutrition();
            }
            return score - (score2 += n);
        });
    }

    @Override
    protected void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FoodItemListModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ItemStorage)FoodItemListModuleWindow.this.currentDisplayedList.get(index)).getItemStack();
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.getItem().getName(resource).plainCopy());
                resourceLabel.setColors(7);
                ItemIcon itemIcon = (ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
                itemIcon.setItem(resource);
                boolean isAllowedItem = FoodItemListModuleWindow.this.buildingView.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(FoodItemListModuleWindow.this.id)).isAllowedItem(new ItemStorage(resource));
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                Gradient gradient = (Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class);
                Item item = resource.getItem();
                if (item instanceof IMinecoloniesFoodItem) {
                    IMinecoloniesFoodItem foodItem = (IMinecoloniesFoodItem)item;
                    if (foodItem.getTier() == 3) {
                        gradient.setGradientStart(255, 215, 0, 255);
                        gradient.setGradientEnd(255, 215, 0, 255);
                    } else if (foodItem.getTier() == 2) {
                        gradient.setGradientStart(211, 211, 211, 255);
                        gradient.setGradientEnd(211, 211, 211, 255);
                    } else if (foodItem.getTier() == 1) {
                        gradient.setGradientStart(205, 127, 50, 255);
                        gradient.setGradientEnd(205, 127, 50, 255);
                    }
                } else {
                    gradient.setGradientStart(0, 0, 0, 0);
                    gradient.setGradientEnd(0, 0, 0, 0);
                }
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.translatable((String)"com.minecolonies.core.gui.restaurant.foodquality", (Object[])new Object[]{FoodUtils.getBuildingLevelForFood(resource)}))).hoverPane((Pane)gradient).build();
                if (FoodItemListModuleWindow.this.isInverted && !isAllowedItem || !FoodItemListModuleWindow.this.isInverted && isAllowedItem) {
                    switchButton.setText(Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
                } else {
                    switchButton.setText(Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
                }
            }
        });
    }
}

