/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.core.client.gui.citizen.AbstractWindowCitizen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FamilyWindowCitizen
extends AbstractWindowCitizen {
    protected final ScrollingList siblingList = (ScrollingList)this.findPaneOfTypeByID("siblings", ScrollingList.class);
    protected final ScrollingList childrenList = (ScrollingList)this.findPaneOfTypeByID("children", ScrollingList.class);

    public FamilyWindowCitizen(ICitizenDataView citizen) {
        super(citizen, new ResourceLocation("minecolonies", "gui/citizen/family.xml"));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        String firstParent = this.citizen.getParents().getA();
        String secondParent = this.citizen.getParents().getB();
        ((Text)this.findPaneOfTypeByID("parentA", Text.class)).setText(firstParent.isEmpty() ? Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.family.unknown", (Object[])new Object[0]) : Component.literal((String)firstParent));
        ((Text)this.findPaneOfTypeByID("parentB", Text.class)).setText(secondParent.isEmpty() ? Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.family.unknown", (Object[])new Object[0]) : Component.literal((String)secondParent));
        int partner = this.citizen.getPartner();
        ICitizenDataView partnerView = this.colony.getCitizen(partner);
        Text partnerText = (Text)this.findPaneOfTypeByID("partner", Text.class);
        if (partnerView == null) {
            partnerText.setText(Component.literal((String)"-"));
        } else {
            partnerText.setText(Component.literal((String)partnerView.getName()));
        }
        this.childrenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getChildren().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getChildren().get(index)).getName()));
            }
        });
        this.siblingList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getSiblings().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getSiblings().get(index)).getName()));
            }
        });
    }
}

