/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.client.gui.AbstractWindowRequestTree;
import com.minecolonies.core.client.gui.citizen.FamilyWindowCitizen;
import com.minecolonies.core.client.gui.citizen.HappinessWindowCitizen;
import com.minecolonies.core.client.gui.citizen.JobWindowCitizen;
import com.minecolonies.core.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.core.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.gui.DebugWindowCitizen;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class AbstractWindowCitizen
extends AbstractWindowRequestTree {
    protected final ICitizenDataView citizen;

    public AbstractWindowCitizen(ICitizenDataView citizen, ResourceLocation ui) {
        super(IColonyManager.getInstance().getColonyView(citizen.getColonyId(), (ResourceKey<Level>)Minecraft.getInstance().level.dimension()), citizen.getWorkBuilding(), ui);
        IBuildingView building;
        this.citizen = citizen;
        this.registerButton("mainTab", () -> new MainWindowCitizen(citizen).open());
        this.registerButton("mainIcon", () -> new MainWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("mainIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.main", (Object[])new Object[0]));
        this.registerButton("requestTab", () -> new RequestWindowCitizen(citizen).open());
        this.registerButton("requestIcon", () -> new RequestWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("requestIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.requests", (Object[])new Object[0]));
        this.registerButton("inventoryTab", () -> new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId()).sendToServer());
        this.registerButton("inventoryIcon", () -> new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId()).sendToServer());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("inventoryIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.inventory", (Object[])new Object[0]));
        this.registerButton("happinessTab", () -> new HappinessWindowCitizen(citizen).open());
        this.registerButton("happinessIcon", () -> new HappinessWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("happinessIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.happiness", (Object[])new Object[0]));
        this.registerButton("familyTab", () -> new FamilyWindowCitizen(citizen).open());
        this.registerButton("familyIcon", () -> new FamilyWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("familyIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.family", (Object[])new Object[0]));
        if (DebugPlayerManager.hasDebugEnabled((Player)this.mc.player)) {
            this.findPaneByID("debugTab").setVisible(true);
            this.findPaneByID("debugIcon").setVisible(true);
            this.registerButton("debugTab", () -> new DebugWindowCitizen(citizen).open());
            this.registerButton("debugIcon", () -> new DebugWindowCitizen(citizen).open());
            PaneBuilders.singleLineTooltip((MutableComponent)Component.translatable((String)"com.minecolonies.coremod.debug.gui.tabicon"), (Pane)this.findPaneByID("debugIcon"));
        }
        if ((building = this.colony.getBuilding(citizen.getWorkBuilding())) instanceof AbstractBuildingView && building.getBuildingType() != ModBuildings.library.get()) {
            this.findPaneByID("jobTab").setVisible(true);
            this.findPaneByID("jobIcon").setVisible(true);
            this.registerButton("jobTab", () -> new JobWindowCitizen(citizen).open());
            this.registerButton("jobIcon", () -> new JobWindowCitizen(citizen).open());
            PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("jobIcon")).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.job", (Object[])new Object[0]));
        } else {
            this.findPaneByID("jobTab").setVisible(false);
            this.findPaneByID("jobIcon").setVisible(false);
        }
    }
}

