/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks.decorative;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.minecolonies.api.blocks.decorative.AbstractColonyFlagBanner;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockColonyFlagWallBanner
extends AbstractColonyFlagBanner<BlockColonyFlagWallBanner> {
    public static final MapCodec<BlockColonyFlagWallBanner> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(AbstractBannerBlock::getColor), (App)BlockColonyFlagWallBanner.propertiesCodec()).apply((Applicative)builder, BlockColonyFlagWallBanner::new));
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> BANNER_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.WEST, (Object)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.5, (double)16.0)));

    public BlockColonyFlagWallBanner() {
        this(DyeColor.WHITE, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).noCollission().strength(1.0f).sound(SoundType.WOOD));
    }

    public BlockColonyFlagWallBanner(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<BlockColonyFlagWallBanner> codec() {
        return CODEC;
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.relative(((Direction)state.getValue((Property)HORIZONTAL_FACING)).getOpposite())).isSolid();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == ((Direction)stateIn.getValue((Property)HORIZONTAL_FACING)).getOpposite() && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BANNER_SHAPES.get(state.getValue((Property)HORIZONTAL_FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level iworldreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)HORIZONTAL_FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING});
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", "colony_wall_banner");
    }
}

