/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.core.items.ItemColonySign;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockColonySign
extends AbstractBlockMinecolonies<BlockColonySign>
implements ITickableBlockMinecolonies {
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "colonysign";
    private static final float RESISTANCE = 1.0f;
    private static final VoxelShape SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockColonySign() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(5.0f, 1.0f).noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn.isClientSide) {
            super.setPlacedBy(worldIn, pos, state, placer, stack);
            return;
        }
        TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)worldIn.getBlockEntity(pos);
        ColonyId colonyComponent = ColonyId.readFromItemStack(stack);
        if (!colonyComponent.hasColonyId()) {
            return;
        }
        BuildingId buildingId = BuildingId.readFromItemStack(stack);
        int colonyId = colonyComponent.id();
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)worldIn.dimension());
        tileEntityColonySign.setColonyAndAnchor(colony, buildingId.hasId() ? buildingId.id() : null);
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
    }

    public void onRemove(BlockState currentState, Level level, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (!level.isClientSide && tileEntity instanceof TileEntityColonySign) {
            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)tileEntity;
            IColony colony = IColonyManager.getInstance().getColonyByDimension(tileEntityColonySign.getColonyId(), (ResourceKey<Level>)level.dimension());
            if (colony != null) {
                colony.getConnectionManager().removeConnectionNode(pos);
            }
        }
        super.onRemove(currentState, level, pos, p_60518_, p_60519_);
    }

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, CONNECTED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntityColonySign(blockPos, blockState);
    }

    @Override
    public void registerBlockItem(Registry<Item> registry, Item.Properties properties) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)((Object)new ItemColonySign(properties)));
    }
}

