/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.other.MinecoloniesMinecart;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.EntityMercenary;
import com.minecolonies.core.entity.mobs.camp.amazons.EntityAmazonChief;
import com.minecolonies.core.entity.mobs.camp.amazons.EntityAmazonSpearman;
import com.minecolonies.core.entity.mobs.camp.amazons.EntityArcherAmazon;
import com.minecolonies.core.entity.mobs.camp.barbarians.EntityArcherBarbarian;
import com.minecolonies.core.entity.mobs.camp.barbarians.EntityBarbarian;
import com.minecolonies.core.entity.mobs.camp.barbarians.EntityChiefBarbarian;
import com.minecolonies.core.entity.mobs.camp.drownedpirates.EntityDrownedArcherPirate;
import com.minecolonies.core.entity.mobs.camp.drownedpirates.EntityDrownedCaptainPirate;
import com.minecolonies.core.entity.mobs.camp.drownedpirates.EntityDrownedPirate;
import com.minecolonies.core.entity.mobs.camp.egyptians.EntityArcherMummy;
import com.minecolonies.core.entity.mobs.camp.egyptians.EntityMummy;
import com.minecolonies.core.entity.mobs.camp.egyptians.EntityPharao;
import com.minecolonies.core.entity.mobs.camp.norsemen.EntityNorsemenArcher;
import com.minecolonies.core.entity.mobs.camp.norsemen.EntityNorsemenChief;
import com.minecolonies.core.entity.mobs.camp.norsemen.EntityShieldmaiden;
import com.minecolonies.core.entity.mobs.camp.pirates.EntityArcherPirate;
import com.minecolonies.core.entity.mobs.camp.pirates.EntityCaptainPirate;
import com.minecolonies.core.entity.mobs.camp.pirates.EntityPirate;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityAmazonChiefRaider;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityAmazonSpearmanRaider;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityArcherAmazonRaider;
import com.minecolonies.core.entity.mobs.raider.barbarians.EntityArcherBarbarianRaider;
import com.minecolonies.core.entity.mobs.raider.barbarians.EntityBarbarianRaider;
import com.minecolonies.core.entity.mobs.raider.barbarians.EntityChiefBarbarianRaider;
import com.minecolonies.core.entity.mobs.raider.drownedpirates.EntityDrownedArcherPirateRaider;
import com.minecolonies.core.entity.mobs.raider.drownedpirates.EntityDrownedCaptainPirateRaider;
import com.minecolonies.core.entity.mobs.raider.drownedpirates.EntityDrownedPirateRaider;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityArcherMummyRaider;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityMummyRaider;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityPharaoRaider;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityNorsemenArcherRaider;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityNorsemenChiefRaider;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityShieldmaidenRaider;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityArcherPirateRaider;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityCaptainPirateRaider;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityPirateRaider;
import com.minecolonies.core.entity.other.CustomArrowEntity;
import com.minecolonies.core.entity.other.DruidPotionEntity;
import com.minecolonies.core.entity.other.FireArrowEntity;
import com.minecolonies.core.entity.other.NewBobberEntity;
import com.minecolonies.core.entity.other.SittingEntity;
import com.minecolonies.core.entity.other.SpearEntity;
import com.minecolonies.core.entity.visitor.VisitorCitizen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="minecolonies", bus=EventBusSubscriber.Bus.MOD)
public class EntityInitializer {
    public static void setupEntities(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            @Nullable Registry registry = event.getRegistry(Registries.ENTITY_TYPE);
            ModEntities.CITIZEN = EntityInitializer.build(registry, "citizen", EntityType.Builder.of(EntityCitizen::new, (MobCategory)MobCategory.CREATURE).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f).setShouldReceiveVelocityUpdates(true));
            ModEntities.FISHHOOK = EntityInitializer.build(registry, "fishhook", EntityType.Builder.of(NewBobberEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(5).sized(0.25f, 0.25f).setShouldReceiveVelocityUpdates(true));
            ModEntities.VISITOR = EntityInitializer.build(registry, "visitor", EntityType.Builder.of(VisitorCitizen::new, (MobCategory)MobCategory.CREATURE).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f).setShouldReceiveVelocityUpdates(true));
            ModEntities.MERCENARY = EntityInitializer.build(registry, "mercenary", EntityType.Builder.of(EntityMercenary::new, (MobCategory)MobCategory.CREATURE).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.BARBARIAN = EntityInitializer.build(registry, "barbarian", EntityType.Builder.of(EntityBarbarianRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.ARCHERBARBARIAN = EntityInitializer.build(registry, "archerbarbarian", EntityType.Builder.of(EntityArcherBarbarianRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CHIEFBARBARIAN = EntityInitializer.build(registry, "chiefbarbarian", EntityType.Builder.of(EntityChiefBarbarianRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.PIRATE = EntityInitializer.build(registry, "pirate", EntityType.Builder.of(EntityPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.ARCHERPIRATE = EntityInitializer.build(registry, "archerpirate", EntityType.Builder.of(EntityArcherPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CHIEFPIRATE = EntityInitializer.build(registry, "chiefpirate", EntityType.Builder.of(EntityCaptainPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.SITTINGENTITY = EntityInitializer.build(registry, "sittingentity", EntityType.Builder.of(SittingEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(2).sized(0.0f, 0.5f));
            ModEntities.MINECART = EntityInitializer.build(registry, "mcminecart", EntityType.Builder.of(MinecoloniesMinecart::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(2).sized(0.98f, 0.7f));
            ModEntities.MUMMY = EntityInitializer.build(registry, "mummy", EntityType.Builder.of(EntityMummyRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.ARCHERMUMMY = EntityInitializer.build(registry, "archermummy", EntityType.Builder.of(EntityArcherMummyRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.PHARAO = EntityInitializer.build(registry, "pharao", EntityType.Builder.of(EntityPharaoRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.AMAZON = EntityInitializer.build(registry, "amazon", EntityType.Builder.of(EntityArcherAmazonRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.AMAZONSPEARMAN = EntityInitializer.build(registry, "amazonspearman", EntityType.Builder.of(EntityAmazonSpearmanRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.AMAZONCHIEF = EntityInitializer.build(registry, "amazonchief", EntityType.Builder.of(EntityAmazonChiefRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.FIREARROW = EntityInitializer.build(registry, "firearrow", EntityType.Builder.of(FireArrowEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(5).sized(0.5f, 0.5f).setShouldReceiveVelocityUpdates(true));
            ModEntities.MC_NORMAL_ARROW = EntityInitializer.build(registry, "mcnormalarrow", EntityType.Builder.of(CustomArrowEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(5).sized(0.5f, 0.5f).setShouldReceiveVelocityUpdates(true));
            ModEntities.DRUID_POTION = EntityInitializer.build(registry, "druidpotion", EntityType.Builder.of(DruidPotionEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(5).sized(0.25f, 0.25f).setShouldReceiveVelocityUpdates(true));
            ModEntities.SHIELDMAIDEN = EntityInitializer.build(registry, "shieldmaiden", EntityType.Builder.of(EntityShieldmaidenRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.NORSEMEN_ARCHER = EntityInitializer.build(registry, "norsemenarcher", EntityType.Builder.of(EntityNorsemenArcherRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.NORSEMEN_CHIEF = EntityInitializer.build(registry, "norsemenchief", EntityType.Builder.of(EntityNorsemenChiefRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.SPEAR = EntityInitializer.build(registry, "spear", EntityType.Builder.of(SpearEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(256).setUpdateInterval(5).sized(0.5f, 0.5f).setShouldReceiveVelocityUpdates(true));
            ModEntities.DROWNED_PIRATE = EntityInitializer.build(registry, "drownedpirate", EntityType.Builder.of(EntityDrownedPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.DROWNED_ARCHERPIRATE = EntityInitializer.build(registry, "drownedarcherpirate", EntityType.Builder.of(EntityDrownedArcherPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.DROWNED_CHIEFPIRATE = EntityInitializer.build(registry, "drownedchiefpirate", EntityType.Builder.of(EntityDrownedCaptainPirateRaider::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_BARBARIAN = EntityInitializer.build(registry, "campbarbarian", EntityType.Builder.of(EntityBarbarian::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_ARCHERBARBARIAN = EntityInitializer.build(registry, "camparcherbarbarian", EntityType.Builder.of(EntityArcherBarbarian::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_CHIEFBARBARIAN = EntityInitializer.build(registry, "campchiefbarbarian", EntityType.Builder.of(EntityChiefBarbarian::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_PIRATE = EntityInitializer.build(registry, "camppirate", EntityType.Builder.of(EntityPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_ARCHERPIRATE = EntityInitializer.build(registry, "camparcherpirate", EntityType.Builder.of(EntityArcherPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_CHIEFPIRATE = EntityInitializer.build(registry, "campchiefpirate", EntityType.Builder.of(EntityCaptainPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_AMAZON = EntityInitializer.build(registry, "campamazon", EntityType.Builder.of(EntityArcherAmazon::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_AMAZONSPEARMAN = EntityInitializer.build(registry, "campamazonspearman", EntityType.Builder.of(EntityAmazonSpearman::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_AMAZONCHIEF = EntityInitializer.build(registry, "campamazonchief", EntityType.Builder.of(EntityAmazonChief::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_MUMMY = EntityInitializer.build(registry, "campmummy", EntityType.Builder.of(EntityMummy::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_ARCHERMUMMY = EntityInitializer.build(registry, "camparchermummy", EntityType.Builder.of(EntityArcherMummy::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_PHARAO = EntityInitializer.build(registry, "camppharao", EntityType.Builder.of(EntityPharao::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_SHIELDMAIDEN = EntityInitializer.build(registry, "campshieldmaiden", EntityType.Builder.of(EntityShieldmaiden::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_NORSEMEN_ARCHER = EntityInitializer.build(registry, "campnorsemenarcher", EntityType.Builder.of(EntityNorsemenArcher::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_NORSEMEN_CHIEF = EntityInitializer.build(registry, "campnorsemenchief", EntityType.Builder.of(EntityNorsemenChief::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_DROWNED_PIRATE = EntityInitializer.build(registry, "campdrownedpirate", EntityType.Builder.of(EntityDrownedPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_DROWNED_ARCHERPIRATE = EntityInitializer.build(registry, "campdrownedarcherpirate", EntityType.Builder.of(EntityDrownedArcherPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
            ModEntities.CAMP_DROWNED_CHIEFPIRATE = EntityInitializer.build(registry, "campdrownedchiefpirate", EntityType.Builder.of(EntityDrownedCaptainPirate::new, (MobCategory)MobCategory.MONSTER).setTrackingRange(256).setUpdateInterval(2).sized(0.6f, 1.8f));
        }
    }

    private static <T extends Entity> EntityType<T> build(Registry<EntityType<?>> registry, String key, EntityType.Builder<T> builder) {
        EntityType entity = builder.build("minecolonies:" + key);
        Registry.register(registry, (ResourceLocation)ResourceLocation.parse((String)("minecolonies:" + key)), (Object)entity);
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegisterEvent event) {
        EntityInitializer.setupEntities(event);
    }
}

