/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class NBTUtils {
    public static Stream<CompoundTag> streamCompound(ListTag list) {
        return NBTUtils.streamBase(list).filter(b -> b instanceof CompoundTag).map(b -> (CompoundTag)b);
    }

    public static Stream<Tag> streamBase(ListTag list) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TagListIterator(list), 16), false);
    }

    public static Collector<Tag, ?, ListTag> toListNBT() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            ListTag tagList = new ListTag();
            tagList.addAll((Collection)list);
            return tagList;
        });
    }

    public static BlockPos readBlockPos(@NotNull CompoundTag compound, @NotNull String name) {
        int[] aint = compound.getIntArray(name);
        return aint.length == 3 ? new BlockPos(aint[0], aint[1], aint[2]) : null;
    }

    public static BlockPos readBlockPos(@NotNull Tag compound) {
        int[] aint = ((IntArrayTag)compound).getAsIntArray();
        return aint.length == 3 ? new BlockPos(aint[0], aint[1], aint[2]) : null;
    }

    public static Tag writeBlockPos(@NotNull BlockPos pos) {
        return new IntArrayTag(new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    private static class TagListIterator
    implements Iterator<Tag> {
        private final ListTag list;
        private int currentIndex = 0;

        private TagListIterator(ListTag list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.list.size();
        }

        @Override
        public Tag next() {
            return this.list.getCompound(this.currentIndex++);
        }
    }
}

