/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.requirements.BuildingResearchRequirement;
import com.minecolonies.core.util.GsonHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BuildingAlternatesResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDINGS_LIST = "building-list";
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP = "alternate-buildings";
    private static final String RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP = "level";
    private final Set<ResourceLocation> buildings = new HashSet<ResourceLocation>();
    private final int buildingLevel;

    public BuildingAlternatesResearchRequirement(CompoundTag nbt) {
        this.buildingLevel = nbt.getInt(TAG_BUILDING_LVL);
        ListTag buildingsNBT = nbt.getList(TAG_BUILDINGS_LIST, 10);
        for (int i = 0; i < buildingsNBT.size(); ++i) {
            CompoundTag buildingNBT = buildingsNBT.getCompound(i);
            this.buildings.add(BuildingResearchRequirement.parseFallbackBuildingKey(buildingNBT.getString(TAG_BUILDING_NAME)));
        }
    }

    public BuildingAlternatesResearchRequirement(JsonObject json) {
        this.buildingLevel = GsonHelper.getAsInt((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP);
        for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)json, (String)RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP)) {
            String arrBuilding = element.getAsString();
            this.buildings.add(BuildingResearchRequirement.parseFallbackBuildingKey(arrBuilding));
        }
    }

    public Set<ResourceLocation> getBuildings() {
        return this.buildings;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.buildingAlternatesResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        MutableComponent requirementList = Component.literal((String)"");
        Iterator<ResourceLocation> iterator = this.buildings.iterator();
        while (iterator.hasNext()) {
            ResourceLocation building = iterator.next();
            BuildingEntry buildingEntry = (BuildingEntry)IBuildingRegistry.getInstance().get(building);
            MutableComponent buildingName = buildingEntry != null ? Component.translatable((String)buildingEntry.getTranslationKey()) : Component.empty();
            requirementList.append((Component)Component.translatable((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{buildingName, this.buildingLevel}));
            if (!iterator.hasNext()) continue;
            requirementList.append((Component)Component.translatable((String)"com.minecolonies.coremod.research.requirement.building.or"));
        }
        return requirementList;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        for (ResourceLocation requirement : this.buildings) {
            if (!colony.hasBuilding(requirement, this.buildingLevel, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(TAG_BUILDING_LVL, this.buildingLevel);
        ListTag buildingsNBT = new ListTag();
        for (ResourceLocation building : this.buildings) {
            CompoundTag indNBT = new CompoundTag();
            indNBT.putString(TAG_BUILDING_NAME, building.toString());
            buildingsNBT.add((Object)indNBT);
        }
        nbt.put(TAG_BUILDINGS_LIST, (Tag)buildingsNBT);
        return nbt;
    }
}

