/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.entity.ai.workers.util.GuardGearBuilder;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCitizenInventory
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final int inventorySize;
    private ICitizen citizenData;
    private Optional<? extends Entity> entity = Optional.empty();
    private String displayName;

    public static ContainerCitizenInventory fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        int colonyId = packetBuffer.readVarInt();
        int citizenId = packetBuffer.readVarInt();
        return new ContainerCitizenInventory(windowId, inv, colonyId, citizenId);
    }

    public ContainerCitizenInventory(int windowId, Inventory inv, int colonyId, final int citizenId) {
        super((MenuType)ModContainers.citizenInv.get(), windowId);
        int i;
        BlockPos workBuilding;
        InventoryCitizen inventory;
        this.playerInventory = inv;
        final IColony colony = inv.player.level().isClientSide ? IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)inv.player.level().dimension()) : IColonyManager.getInstance().getColonyByWorld(colonyId, inv.player.level());
        if (colony == null) {
            this.inventorySize = 0;
            return;
        }
        int workBuildingLevel = 0;
        if (inv.player.level().isClientSide) {
            data = ((IColonyView)colony).getCitizen(citizenId);
            this.entity = Optional.of(inv.player.level().getEntity(data.getEntityId()));
            this.citizenData = data;
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding();
            if (workBuilding != null) {
                workBuildingLevel = ((IColonyView)colony).getBuilding(workBuilding).getBuildingLevel();
            }
        } else {
            data = citizenId > 0 ? colony.getCitizenManager().getCivilian(citizenId) : (ICitizenData)colony.getVisitorManager().getCivilian(citizenId);
            this.entity = data.getEntity();
            this.citizenData = data;
            inventory = data.getInventory();
            this.displayName = data.getName();
            BlockPos blockPos = workBuilding = data.getWorkBuilding() == null ? null : data.getWorkBuilding().getID();
            if (workBuilding != null) {
                workBuildingLevel = data.getWorkBuilding().getBuildingLevel();
            }
        }
        this.inventorySize = inventory.getSlots() / 9;
        int size = inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = (this.inventorySize <= 8 ? 0 : 2) + 1;
        int newOffset = 5;
        int index = 0;
        final List guardGear = switch (workBuildingLevel) {
            case 5 -> GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE);
            case 4 -> GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE);
            case 3 -> GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE);
            case 2 -> GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE);
            case 1 -> GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE);
            default -> Collections.emptyList();
        };
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, index, 8 + k * 18, 23 + j * 18){

                    public void set(@NotNull ItemStack stack) {
                        if (workBuilding != null && !ContainerCitizenInventory.this.playerInventory.player.level().isClientSide && !ItemStackUtils.isEmpty(stack)) {
                            IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                            ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                            building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                        }
                        super.set(stack);
                    }
                });
                ++index;
            }
        }
        index = 3;
        int eqIndex = 0;
        for (final EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.addSlot(new Slot((Container)new SimpleContainer(new ItemStack[]{inventory.getArmorInSlot(equipmentSlot)}), 0, 223, 23 + eqIndex * 18){

                public void set(@NotNull ItemStack stack) {
                    if (workBuilding != null && !ContainerCitizenInventory.this.playerInventory.player.level().isClientSide && !ItemStackUtils.isEmpty(stack)) {
                        IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                        ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                        building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                    }
                    super.set(stack);
                    inventory.forceArmorStackToSlot(equipmentSlot, stack);
                }

                public ItemStack remove(int slot) {
                    inventory.forceClearArmorInSlot(equipmentSlot, inventory.getArmorInSlot(equipmentSlot));
                    return super.remove(slot);
                }

                public boolean mayPlace(ItemStack stack) {
                    ArmorItem armorItem;
                    Item item = stack.getItem();
                    if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getEquipmentSlot() == equipmentSlot) {
                        for (GuardGear gear : guardGear) {
                            if (!gear.test(stack)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            });
            --index;
            ++eqIndex;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 35 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, 8 + i * 18, 93 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.getItem().copy();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.moveItemStackTo(stackCopy, maxIndex, this.slots.size(), true) : !this.moveItemStackTo(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.set(ItemStackUtils.EMPTY);
        } else {
            slot.set(stackCopy);
        }
        return stackCopy;
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Optional<? extends Entity> getEntity() {
        return this.entity;
    }

    public ICitizen getCitizenData() {
        return this.citizenData;
    }
}

