/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.collect.Lists;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZeroWasteRecipe
extends ShapelessRecipe {
    public ZeroWasteRecipe(@NotNull ItemStack output, @NotNull NonNullList<Ingredient> inputs) {
        super("", CraftingBookCategory.MISC, output, inputs);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)input);
        Collections.fill(remainingItems, ItemStack.EMPTY);
        return remainingItems;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializer.ZeroWasteRecipeSerializer.get();
    }

    public static Builder build(@NotNull RecipeCategory category, @NotNull ItemLike output, int count) {
        return new Builder(category, new ItemStack(output, count));
    }

    public static Builder build(@NotNull RecipeCategory category, @NotNull ItemStack output) {
        return new Builder(category, output);
    }

    public static class Builder
    implements RecipeBuilder {
        private final RecipeCategory category;
        private final ItemStack output;
        private final List<Ingredient> ingredients = Lists.newArrayList();
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        public Builder(@NotNull RecipeCategory category, @NotNull ItemStack output) {
            this.category = category;
            this.output = output;
        }

        public Builder requires(@NotNull TagKey<Item> tag) {
            return this.requires(Ingredient.of(tag));
        }

        public Builder requires(@NotNull ItemLike item) {
            return this.requires(item, 1);
        }

        public Builder requires(@NotNull ItemLike item, int count) {
            for (int i = 0; i < count; ++i) {
                this.requires(Ingredient.of((ItemLike[])new ItemLike[]{item}));
            }
            return this;
        }

        public Builder requires(@NotNull Ingredient ingredient) {
            return this.requires(ingredient, 1);
        }

        public Builder requires(@NotNull Ingredient ingredient, int count) {
            for (int i = 0; i < count; ++i) {
                this.ingredients.add(ingredient);
            }
            return this;
        }

        @NotNull
        public Builder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.output.getItem();
        }

        @NotNull
        public RecipeBuilder group(@Nullable String group) {
            return this;
        }

        public void save(@NotNull RecipeOutput consumer, @NotNull ResourceLocation id) {
            this.ensureValid(id);
            ZeroWasteRecipe recipe = new ZeroWasteRecipe(this.output, (NonNullList<Ingredient>)NonNullList.copyOf(this.ingredients));
            Advancement.Builder advancementBuilder = consumer.advancement();
            advancementBuilder.addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
            AdvancementHolder advancement = advancementBuilder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/"));
            consumer.accept(id, (Recipe)recipe, advancement);
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<ZeroWasteRecipe> {
        private static final MapCodec<ZeroWasteRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.getResultItem(null)), (App)NonNullList.codecOf((Codec)Ingredient.CODEC_NONEMPTY).fieldOf("ingredients").forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)builder, ZeroWasteRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ZeroWasteRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ZeroWasteRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ZeroWasteRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ZeroWasteRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buf) {
            int count = buf.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            inputs.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new ZeroWasteRecipe(output, (NonNullList<Ingredient>)inputs);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buf, @NotNull ZeroWasteRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient input : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)input);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResultItem(null));
        }
    }
}

