/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import org.jetbrains.annotations.NotNull;

public class Burnable
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Burnable.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Burnable(int count) {
        this.count = count;
    }

    public Burnable(int count, @NotNull ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static CompoundTag serialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, Burnable burnable) {
        CompoundTag compound = new CompoundTag();
        compound.putInt(NBT_COUNT, burnable.count);
        if (!ItemStackUtils.isEmpty(burnable.result)) {
            compound.put(NBT_RESULT, burnable.result.saveOptional(provider));
        }
        return compound;
    }

    public static Burnable deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        int count = compound.getInt(NBT_COUNT);
        ItemStack result = compound.contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.getCompound(NBT_RESULT), provider) : ItemStackUtils.EMPTY;
        return new Burnable(count, result);
    }

    public static void serialize(IFactoryController controller, RegistryFriendlyByteBuf buffer, Burnable input) {
        buffer.writeInt(input.count);
        buffer.writeBoolean(!ItemStackUtils.isEmpty(input.result));
        if (!ItemStackUtils.isEmpty(input.result)) {
            Utils.serializeCodecMess(buffer, input.result);
        }
    }

    public static Burnable deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? Utils.deserializeCodecMess(buffer) : ItemStack.EMPTY;
        return new Burnable(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return FurnaceBlockEntity.isFuel((ItemStack)stack);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Burnable(newCount);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Burnable)) {
            return false;
        }
        Burnable burnable = (Burnable)o;
        if (this.getCount() != burnable.getCount()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), burnable.getResult());
    }

    public int hashCode() {
        int result1 = this.getCount();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

