/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.request;

import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;

public class RequestUtils {
    private RequestUtils() {
    }

    public static boolean requestChainNeedsPlayer(IToken<?> token, IRequestManager manager) {
        IRequest<?> request = manager.getRequestForToken(token);
        if (request == null) {
            return false;
        }
        if (request.hasChildren()) {
            for (IToken childToken : request.getChildren()) {
                if (!RequestUtils.requestChainNeedsPlayer(childToken, manager)) continue;
                return true;
            }
        } else {
            IRequestResolver<?> resolver = manager.getResolverForRequest(token);
            return request.getState() == RequestState.IN_PROGRESS && (resolver instanceof IPlayerRequestResolver || resolver instanceof IRetryingRequestResolver);
        }
        return false;
    }
}

