/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.util.Tuple;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInteractionResponseHandler
implements IInteractionResponseHandler {
    private Component inquiry;
    private Map<Component, Component> responses = new LinkedHashMap<Component, Component>();
    private boolean primary;
    private IChatPriority priority;

    @SafeVarargs
    public AbstractInteractionResponseHandler(@NotNull Component inquiry, boolean primary, IChatPriority priority, Tuple<Component, Component> ... responseTuples) {
        this.inquiry = inquiry;
        this.primary = primary;
        this.priority = priority;
        for (Tuple<Component, Component> element : responseTuples) {
            this.responses.put(element.getA(), element.getB());
        }
    }

    public AbstractInteractionResponseHandler() {
    }

    @Override
    public Component getInquiry() {
        return this.inquiry;
    }

    @Override
    @Nullable
    public Component getResponseResult(Component response) {
        return this.responses.getOrDefault(response, null);
    }

    @Override
    public List<Component> getPossibleResponses() {
        return ImmutableList.copyOf(this.responses.keySet());
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString("inquiry", Component.Serializer.toJson((Component)this.inquiry, (HolderLookup.Provider)provider));
        ListTag list = new ListTag();
        for (Map.Entry<Component, Component> element : this.responses.entrySet()) {
            CompoundTag elementTag = new CompoundTag();
            elementTag.putString("response", Component.Serializer.toJson((Component)element.getKey(), (HolderLookup.Provider)provider));
            elementTag.putString("nextinquiry", Component.Serializer.toJson((Component)element.getValue(), (HolderLookup.Provider)provider));
            list.add((Object)elementTag);
        }
        tag.put("responses", (Tag)list);
        tag.putBoolean("primary", this.isPrimary());
        tag.putInt("priority", this.priority.getPriority());
        tag.putString("handlertype", this.getType());
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        this.inquiry = Component.Serializer.fromJson((String)compoundNBT.getString("inquiry"), (HolderLookup.Provider)provider);
        ListTag list = compoundNBT.getList("responses", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.getCompound(i);
            this.responses.put((Component)Component.Serializer.fromJson((String)nbt.getString("response"), (HolderLookup.Provider)provider), (Component)Component.Serializer.fromJson((String)nbt.getString("nextinquiry"), (HolderLookup.Provider)provider));
        }
        this.primary = compoundNBT.getBoolean("primary");
        this.priority = ChatPriority.values()[compoundNBT.getInt("priority")];
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public IChatPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean isVisible(Level world) {
        return true;
    }

    @Override
    public boolean isValid(ICitizenData colony) {
        return true;
    }
}

