/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public interface ISetting<S> {
    public ResourceLocation getLayoutItem();

    public void setupHandler(ISettingKey<?> var1, Pane var2, ISettingsModuleView var3, IBuildingView var4, BOWindow var5);

    public void render(ISettingKey<?> var1, Pane var2, ISettingsModuleView var3, IBuildingView var4, BOWindow var5);

    default public void trigger() {
    }

    default public boolean isActive(ISettingsModule module) {
        return true;
    }

    default public boolean shouldHideWhenInactive() {
        return false;
    }

    default public void onUpdate(IBuilding building, ServerPlayer sender) {
    }

    default public void updateSetting(ISetting<?> setting) {
    }

    public void copyValue(ISetting<?> var1);

    default public void setHoverPane(ISettingKey<?> key, Pane component, ISettingsModuleView settingsModuleView) {
        String generalSettingToolTipKey = "com.minecolonies.coremod.setting.tooltip." + key.getUniqueId().toString();
        MutableComponent tooltip = Component.translatable((String)generalSettingToolTipKey);
        Component inActiveReason = this.getInactiveReason();
        boolean hasTooltip = !tooltip.getString().equals(generalSettingToolTipKey);
        boolean isActive = this.isActive(settingsModuleView);
        if (isActive && hasTooltip) {
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((Component)tooltip)).hoverPane(component).build();
        } else if (isActive && this.getToolTipText() != null) {
            PaneBuilders.tooltipBuilder().hoverPane(component).build().setText(this.getToolTipText());
        } else if (!isActive && (hasTooltip || inActiveReason != null)) {
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((Component)(inActiveReason != null ? inActiveReason : tooltip))).hoverPane(component).build();
        } else {
            component.setHoverPane(null);
        }
    }

    @Nullable
    default public Component getInactiveReason() {
        return null;
    }

    default public boolean isActive(ISettingsModuleView module) {
        return true;
    }

    public S getValue();

    @Nullable
    default public Component getToolTipText() {
        return null;
    }
}

