/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CitizenEatFoodTrigger
extends SimpleCriterionTrigger<CitizenEatFoodTriggerInstance> {
    public void trigger(ServerPlayer player, ItemStack foodItemStack) {
        this.trigger(player, trigger -> trigger.test(foodItemStack));
    }

    public Codec<CitizenEatFoodTriggerInstance> codec() {
        return CitizenEatFoodTriggerInstance.CODEC;
    }

    public record CitizenEatFoodTriggerInstance(Optional<ContextAwarePredicate> player, List<ItemPredicate> itemPredicates) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final List<ItemPredicate> DEFAULT_OUTPUT_ITEM_PREDICATES = Collections.emptyList();
        public static final Codec<CitizenEatFoodTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(CitizenEatFoodTriggerInstance::player), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items", DEFAULT_OUTPUT_ITEM_PREDICATES).forGetter(CitizenEatFoodTriggerInstance::itemPredicates)).apply((Applicative)builder, CitizenEatFoodTriggerInstance::new));

        public static Criterion<CitizenEatFoodTriggerInstance> citizenEatFood() {
            return CitizenEatFoodTriggerInstance.citizenEatFood(DEFAULT_OUTPUT_ITEM_PREDICATES);
        }

        public static Criterion<CitizenEatFoodTriggerInstance> citizenEatFood(List<ItemPredicate> itemPredicates) {
            return ((CitizenEatFoodTrigger)((Object)AdvancementTriggers.CITIZEN_EAT_FOOD.get())).createCriterion((CriterionTriggerInstance)new CitizenEatFoodTriggerInstance(Optional.empty(), itemPredicates));
        }

        public boolean test(ItemStack foodItemStack) {
            if (this.itemPredicates != null) {
                for (ItemPredicate itemPredicate : this.itemPredicates) {
                    if (!itemPredicate.test(foodItemStack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

