/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.network.messages;

import com.ldtteam.domumornamentum.container.ArchitectsCutterContainer;
import com.ldtteam.domumornamentum.network.IServerboundDistributor;
import com.ldtteam.domumornamentum.util.Constants;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record CreativeSetArchitectCutterSlotMessage(int slot, ItemStack stack) implements IServerboundDistributor
{
    public static final CustomPacketPayload.Type<CreativeSetArchitectCutterSlotMessage> ID = new CustomPacketPayload.Type(Constants.resLocDO("creative_set_archicutter_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CreativeSetArchitectCutterSlotMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CreativeSetArchitectCutterSlotMessage::slot, (StreamCodec)ItemStack.STREAM_CODEC, CreativeSetArchitectCutterSlotMessage::stack, CreativeSetArchitectCutterSlotMessage::new);

    public CustomPacketPayload.Type<CreativeSetArchitectCutterSlotMessage> type() {
        return ID;
    }

    public void onExecute(@NotNull IPayloadContext ctxIn) {
        Player player = ctxIn.player();
        ctxIn.enqueueWork(() -> this.onExecuteMainThread(player));
    }

    private void onExecuteMainThread(Player player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && player.isCreative() && (abstractContainerMenu = player.containerMenu) instanceof ArchitectsCutterContainer) {
            Slot menuSlot;
            ArchitectsCutterContainer menu = (ArchitectsCutterContainer)abstractContainerMenu;
            if (this.slot >= 0 && this.slot < menu.slots.size() && (menuSlot = (Slot)menu.slots.get(this.slot)).isActive() && menuSlot.allowModification(player) && menuSlot.mayPlace(this.stack)) {
                menuSlot.setByPlayer(this.stack);
            }
        }
    }
}

