/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.vanilla;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class TrapdoorBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final TrapdoorBlock trapdoorBlock;

    public TrapdoorBlockItem(TrapdoorBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.trapdoorBlock = blockIn;
    }

    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.trapdoorBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)"domum_ornamentum.trapdoor.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        TrapdoorType trapdoorType = BlockUtils.getPropertyFromBlockStateTag(stack, TrapdoorBlock.TYPE, TrapdoorType.FULL);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.trapdoor.type.format", (Object[])new Object[]{Component.translatable((String)("domum_ornamentum.trapdoor.type.name." + trapdoorType.getTranslationKeySuffix()))}));
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent trapDoorComponent = (IMateriallyTexturedBlockComponent)this.trapdoorBlock.getComponents().get(0);
        Block trapDoorBlock = textureData.getTexturedComponents().getOrDefault(trapDoorComponent.getId(), trapDoorComponent.getDefault());
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.onlyone", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{BlockUtils.getHoverName(trapDoorBlock)})}));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("etrapdoor");
    }
}

