/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PillarBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private PillarBlock pillarBlock;

    public PillarBlockItem(PillarBlock blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.pillarBlock = blockIn;
    }

    @NotNull
    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent columnComponent = (IMateriallyTexturedBlockComponent)this.pillarBlock.getComponents().get(0);
        Block columnBlock = textureData.getTexturedComponents().getOrDefault(columnComponent.getId(), columnComponent.getDefault());
        Component columnBlockName = BlockUtils.getHoverName(columnBlock);
        return Component.translatable((String)("domum_ornamentum." + ((PillarBlock)this.getBlock()).getRegistryName().getPath() + ".name.format"), (Object[])new Object[]{columnBlockName});
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.pillar.header"));
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)this.pillarBlock.getComponents().get(0);
        Block frameBlock = textureData.getTexturedComponents().getOrDefault(frameComponent.getId(), frameComponent.getDefault());
        Component frameBlockName = BlockUtils.getHoverName(frameBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.onlyone", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{frameBlockName})}));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("gpillar");
    }
}

