/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.DoubleHighBlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class FancyDoorBlockItem
extends DoubleHighBlockItemWithClientBePlacement
implements IDoItem {
    private final FancyDoorBlock doorBlock;

    public FancyDoorBlockItem(FancyDoorBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.doorBlock = blockIn;
    }

    @NotNull
    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)"domum_ornamentum.fancydoor.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        FancyDoorType doorType = BlockUtils.getPropertyFromBlockStateTag(stack, FancyDoorBlock.TYPE, FancyDoorType.FULL);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.fancydoor.type.format", (Object[])new Object[]{Component.translatable((String)("domum_ornamentum.fancydoor.type.name." + doorType.getTranslationKeySuffix()))}));
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent trapDoorComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block trapDoorBlock = textureData.getTexturedComponents().getOrDefault(trapDoorComponent.getId(), trapDoorComponent.getDefault());
        Component trapDoorBlockName = BlockUtils.getHoverName(trapDoorBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorBlockName})}));
        IMateriallyTexturedBlockComponent trapDoorFrameComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(1);
        Block trapDoorFrameBlock = textureData.getTexturedComponents().getOrDefault(trapDoorFrameComponent.getId(), trapDoorFrameComponent.getDefault());
        Component trapDoorFrameBlockName = BlockUtils.getHoverName(trapDoorFrameBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorFrameBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)Constants.resLocDO("frame"), (Object)Constants.resLocDO("center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("ddoor");
    }
}

