/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.stair;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.vanilla.StairBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class StairsBlockStateProvider
extends BlockStateProvider {
    public StairsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getStair());
    }

    private void createBlockstateFile(StairBlock stairBlock) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)stairBlock);
        for (Direction facingValue : net.minecraft.world.level.block.StairBlock.FACING.getPossibleValues()) {
            for (StairsShape shapeValue : net.minecraft.world.level.block.StairBlock.SHAPE.getPossibleValues()) {
                for (Half halfValue : net.minecraft.world.level.block.StairBlock.HALF.getPossibleValues()) {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/stair/" + StairsBlockStateProvider.getTypeFromShape(shapeValue), this.modLoc("block/stair/" + StairsBlockStateProvider.getTypeFromShape(shapeValue) + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).rotationY(this.getYFromFacing(facingValue) + this.getYFromShape(shapeValue) + this.getYFromHalf(halfValue, shapeValue)).rotationX(halfValue == Half.TOP ? 180 : 0).addModel()).condition((Property)net.minecraft.world.level.block.StairBlock.FACING, (Comparable[])new Direction[]{facingValue}).condition((Property)net.minecraft.world.level.block.StairBlock.SHAPE, (Comparable[])new StairsShape[]{shapeValue}).condition((Property)net.minecraft.world.level.block.StairBlock.HALF, (Comparable[])new Half[]{halfValue}).end();
                }
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(stairBlock.getRegistryName().getPath(), this.modLoc("block/stair/stairs"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String getName() {
        return "Stairs BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 0;
            }
            return 90;
        }
        return 0;
    }

    private int getYFromShape(StairsShape shape) {
        return switch (shape) {
            default -> 0;
            case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> -90;
        };
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 90;
            case Direction.WEST -> 180;
            case Direction.NORTH -> 270;
            case Direction.EAST -> 0;
        };
    }

    private static String getTypeFromShape(StairsShape shape) {
        return switch (shape) {
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> "stairs_inner";
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> "stairs_outer";
            default -> "stairs";
        };
    }
}

