/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.util;

import lombok.Generated;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class WorldUtil {

    public static class SolarCheck {
        protected final boolean needsRainCheck;
        protected float peakMultiplier;
        protected final BlockPos pos;
        protected final Level world;
        protected boolean canSeeSun;

        public SolarCheck(Level world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            Biome b = (Biome)this.world.getBiomeManager().getBiome(this.pos).value();
            this.needsRainCheck = b.getPrecipitationAt(this.pos) != Biome.Precipitation.NONE;
            float tempEff = 0.3f * (0.8f - b.getTemperature(this.pos));
            float humidityEff = this.needsRainCheck ? -0.3f * b.getModifiedClimateSettings().downfall() : 0.0f;
            this.peakMultiplier = 1.0f + tempEff + humidityEff;
        }

        public void recheckCanSeeSun() {
            this.canSeeSun = WorldUtils.canSeeSun((Level)this.world, (BlockPos)this.pos);
        }

        public boolean canSeeSun() {
            return this.canSeeSun;
        }

        public float getProductionMultiplier() {
            if (!this.canSeeSun) {
                return 0.0f;
            }
            if (this.needsRainCheck && (this.world.isRaining() || this.world.isThundering())) {
                return this.peakMultiplier * 0.2f;
            }
            return this.peakMultiplier;
        }

        @Generated
        public boolean isNeedsRainCheck() {
            return this.needsRainCheck;
        }

        @Generated
        public float getPeakMultiplier() {
            return this.peakMultiplier;
        }
    }
}

