/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.prefab;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CableUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityMoreMachineGenerator
extends TileEntityMekanism {
    private static final RelativeSide[] ENERGY_SIDES = new RelativeSide[]{RelativeSide.FRONT};
    @Nullable
    private List<BlockEnergyCapabilityCache> outputCaches;
    private long maxOutput;
    private BasicEnergyContainer energyContainer;

    public TileEntityMoreMachineGenerator(Holder<Block> blockProvider, BlockPos pos, BlockState state, @NotNull LongSupplier maxOutput) {
        super(blockProvider, pos, state);
        this.updateMaxOutputRaw(maxOutput.getAsLong());
    }

    protected RelativeSide[] getEnergySides() {
        return ENERGY_SIDES;
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide((Supplier)this.facingSupplier);
        this.energyContainer = BasicEnergyContainer.output((long)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, this.getEnergySides());
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.canFunction()) {
            if (this.outputCaches == null) {
                Direction direction = this.getDirection();
                RelativeSide[] energySides = this.getEnergySides();
                this.outputCaches = new ArrayList<BlockEnergyCapabilityCache>(energySides.length);
                for (RelativeSide energySide : energySides) {
                    Direction side = energySide.getDirection(direction);
                    this.outputCaches.add(BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)this.offSetOutput(this.worldPosition, side), (Direction)side.getOpposite()));
                }
            }
            CableUtils.emit(this.outputCaches, (IEnergyContainer)this.energyContainer, (long)this.getMaxOutput());
        }
        return sendUpdatePacket;
    }

    protected BlockPos offSetOutput(BlockPos from, Direction side) {
        return from.relative(side);
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.outputCaches = null;
    }

    @ComputerMethod
    public long getMaxOutput() {
        return this.maxOutput;
    }

    protected void updateMaxOutputRaw(long maxOutput) {
        this.maxOutput = MathUtils.multiplyClamped((long)maxOutput, (long)2L);
    }

    protected ISyncableData syncableMaxOutput() {
        return SyncableLong.create(this::getMaxOutput, value -> {
            this.maxOutput = value;
        });
    }

    @ComputerMethod(methodDescription="Get the amount of energy produced by this generator in the last tick.")
    protected abstract long getProductionRate();

    @Generated
    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

