/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.config;

import com.jerry.mekmm.common.config.MoreMachineConfigTranslations;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MoreMachineGeneratorsConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedLongValue largeHeatGeneration;
    public final CachedLongValue largeHeatGenerationLava;
    public final CachedLongValue largeHeatGenerationNether;
    public final CachedIntValue largeHeatTankCapacity;
    public final CachedIntValue largeHeatGenerationFluidRate;
    public final CachedLongValue LGBGTankCapacity;

    MoreMachineGeneratorsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT.applyToBuilder(builder).push("large_heat_generator");
        this.largeHeatGeneration = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT_GENERATION, (String)"largeHeatGeneration", (long)1000L);
        this.largeHeatGenerationLava = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT_GEN_LAVA, (String)"largeHeatGenerationLava", (long)350L, (long)0L, (long)113868790578454022L);
        this.largeHeatGenerationNether = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT_GEN_NETHER, (String)"largeHeatGenerationNether", (long)750L);
        this.largeHeatTankCapacity = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT_TANK_CAPACITY.applyToBuilder(builder).defineInRange("tankCapacity", 240000, 1, Integer.MAX_VALUE));
        this.largeHeatGenerationFluidRate = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_HEAT_FLUID_RATE.applyToBuilder(builder).define("largeHeatGenerationFluidRate", (Object)10, value -> {
            Integer i;
            return value instanceof Integer && (i = (Integer)value) > 0 && i <= this.largeHeatTankCapacity.getOrDefault() / 100;
        }));
        builder.pop();
        MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_GAS.applyToBuilder(builder).push("gas_generator");
        this.LGBGTankCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)MoreMachineConfigTranslations.SERVER_GENERATOR_LARGE_GAS_TANK_CAPACITY.applyToBuilder(builder).defineInRange("tankCapacity", 180000L, 1L, Long.MAX_VALUE));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generators";
    }

    public String getTranslation() {
        return "Generators Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

