/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render.tileentity;

import com.jerry.mekmm.client.render.RenderLineHelper;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.item.ItemConnector;
import com.jerry.mekmm.common.tile.TileEntityWirelessTransmissionStation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@NothingNullByDefault
public class RenderWirelessTransmissionStation
extends MekanismTileEntityRenderer<TileEntityWirelessTransmissionStation> {
    public RenderWirelessTransmissionStation(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityWirelessTransmissionStation tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        BlockPos stationPos = tile.getBlockPos();
        Collection<ConnectionConfig> connections = tile.connectionManager.getAllConnections();
        for (ConnectionConfig config : connections) {
            this.renderConnection(matrix, renderer, stationPos, config);
        }
    }

    private void renderConnection(PoseStack matrix, MultiBufferSource renderer, BlockPos tilePos, ConnectionConfig config) {
        Vector3f start = new Vector3f(0.5f, 2.7f, 0.5f);
        BlockPos targetPos = config.pos();
        Direction targetFace = config.direction();
        float relX = targetPos.getX() - tilePos.getX();
        float relY = targetPos.getY() - tilePos.getY();
        float relZ = targetPos.getZ() - tilePos.getZ();
        Vector3f end = new Vector3f(relX + 0.5f, relY + 0.5f, relZ + 0.5f);
        Vector3f faceOffset = this.getFaceOffset(targetFace);
        end.add((Vector3fc)faceOffset);
        ColorRGB color = this.getColorForType(config.type());
        RenderLineHelper.renderLine(matrix, renderer, start, end, color.r, color.g, color.b, 0.15f);
    }

    private Vector3f getFaceOffset(Direction face) {
        float offset = 0.51f;
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> new Vector3f(0.0f, offset, 0.0f);
            case Direction.DOWN -> new Vector3f(0.0f, -offset, 0.0f);
            case Direction.NORTH -> new Vector3f(0.0f, 0.0f, -offset);
            case Direction.SOUTH -> new Vector3f(0.0f, 0.0f, offset);
            case Direction.WEST -> new Vector3f(-offset, 0.0f, 0.0f);
            case Direction.EAST -> new Vector3f(offset, 0.0f, 0.0f);
        };
    }

    private ColorRGB getColorForType(TransmissionType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> new ColorRGB(1.0f, 0.0f, 0.0f);
            case TransmissionType.FLUID -> new ColorRGB(0.0f, 0.4f, 1.0f);
            case TransmissionType.CHEMICAL -> new ColorRGB(1.0f, 1.0f, 0.0f);
            case TransmissionType.ITEM -> new ColorRGB(0.0f, 1.0f, 0.0f);
            case TransmissionType.HEAT -> new ColorRGB(1.0f, 0.5f, 0.0f);
        };
    }

    protected String getProfilerSection() {
        return "wirelessTransmissionStation";
    }

    public boolean shouldRenderOffScreen(TileEntityWirelessTransmissionStation blockEntity) {
        return true;
    }

    public boolean shouldRender(TileEntityWirelessTransmissionStation blockEntity, Vec3 cameraPos) {
        return this.isHandHeldConnector() && super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public AABB getRenderBoundingBox(TileEntityWirelessTransmissionStation blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        if (this.isHandHeldConnector()) {
            return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX(), (double)(pos.getY() + 2), (double)pos.getZ());
        }
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }

    private boolean isHandHeldConnector() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            return mainHand.getItem() instanceof ItemConnector || offHand.getItem() instanceof ItemConnector;
        }
        return false;
    }

    private record ColorRGB(float r, float g, float b) {
    }
}

