/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui.window.connect;

import com.jerry.mekmm.client.render.BlockHighlightManager;
import com.jerry.mekmm.common.MoreMachineLang;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.network.to_server.PacketViewConnection;
import com.jerry.mekmm.common.tile.TileEntityWirelessTransmissionStation;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.PacketUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiViewConnection
extends GuiWindow {
    static int MINER_FILTER_WIDTH = 173;
    protected GuiSequencedSlotDisplay slotDisplay;
    protected final ConnectionConfig config;
    private final Level level;

    public static GuiViewConnection create(IGuiWrapper gui, TileEntityWirelessTransmissionStation tile, Level level, ConnectionConfig config) {
        return new GuiViewConnection(gui, (gui.getXSize() - MINER_FILTER_WIDTH) / 2, 30, tile, level, config);
    }

    private GuiViewConnection(IGuiWrapper gui, int x, int y, TileEntityWirelessTransmissionStation tile, Level level, ConnectionConfig config) {
        super(gui, x, y, MINER_FILTER_WIDTH, 100, SelectedWindowData.UNSPECIFIED);
        this.level = level;
        this.config = config;
        this.addChild((GuiElement)new GuiInnerScreen(this.gui(), this.relativeX + 29, this.relativeY + 18, this.getScreenWidth(), this.getScreenHeight(), this::getScreenText).clearFormat());
        this.addChild((GuiElement)new TranslationButton(this.gui(), this.getLeftButtonX(), this.relativeY + 20 + this.getScreenHeight(), 60, 20, (ILangEntry)MoreMachineLang.BUTTON_DISCONNECT, (element, mouseX, mouseY) -> {
            if (config != null) {
                PacketUtils.sendToServer((CustomPacketPayload)new PacketViewConnection(tile.getBlockPos(), config));
            }
            return this.close(element, mouseX, mouseY);
        }));
        this.addChild((GuiElement)new TranslationButton(this.gui(), this.getLeftButtonX() + 62, this.relativeY + 20 + this.getScreenHeight(), 60, 20, (ILangEntry)MoreMachineLang.BUTTON_HIGHLIGHT, (element, mouseX, mouseY) -> {
            if (config != null) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                switch (config.type()) {
                    case ENERGY: {
                        r = 1.0f;
                        g = 0.0f;
                        b = 0.0f;
                        break;
                    }
                    case FLUID: {
                        r = 0.0f;
                        g = 0.4f;
                        b = 1.0f;
                        break;
                    }
                    case CHEMICAL: {
                        r = 1.0f;
                        g = 1.0f;
                        b = 0.0f;
                        break;
                    }
                    case ITEM: {
                        r = 0.0f;
                        g = 1.0f;
                        b = 0.0f;
                        break;
                    }
                    case HEAT: {
                        r = 1.0f;
                        g = 0.5f;
                        b = 0.0f;
                    }
                }
                BlockHighlightManager.getInstance().addHighlight(config.pos(), 400, r, g, b);
            }
            return this.close(element, mouseX, mouseY);
        }));
        this.slotDisplay = (GuiSequencedSlotDisplay)this.addChild((GuiElement)new GuiSequencedSlotDisplay(this.gui(), this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, this::getRenderStacks));
        this.slotDisplay.updateStackList();
    }

    protected int getSlotOffset() {
        return 18;
    }

    protected int getScreenHeight() {
        return 52;
    }

    public int getScreenWidth() {
        return 116;
    }

    protected int getLeftButtonX() {
        return this.relativeX + this.width / 2 - 61;
    }

    private List<ItemStack> getRenderStacks() {
        if (this.config != null) {
            return List.of(this.level.getBlockState(this.config.pos()).getBlock().asItem().getDefaultInstance());
        }
        return Collections.emptyList();
    }

    protected List<Component> getScreenText() {
        ArrayList<Component> list = new ArrayList<Component>();
        BlockPos pos = this.config.pos();
        Component connectionDescriptor = this.level.getBlockState(pos).getBlock().asItem().getDefaultInstance().getHoverName();
        list.add((Component)MoreMachineLang.LIST_NAME.translate(new Object[]{connectionDescriptor}));
        list.add((Component)MoreMachineLang.LIST_POS.translate(new Object[]{EnumColor.ORANGE, MoreMachineUtils.formatPos(pos)}));
        list.add((Component)MoreMachineLang.LIST_DIRECTION.translate(new Object[]{EnumColor.PINK, this.config.direction()}));
        list.add((Component)MoreMachineLang.LIST_TYPE.translate(new Object[]{MoreMachineUtils.getColorByTransmitterType(this.config.type()), this.config.type()}));
        return list;
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MoreMachineLang.VIEW_CONNECTION.translate(), 6);
    }
}

