/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui;

import com.jerry.mekmm.client.gui.GuiConnectListHolder;
import com.jerry.mekmm.client.gui.window.connect.GuiViewConnection;
import com.jerry.mekmm.common.MoreMachineLang;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.network.to_server.MoreMachinePacketGuiInteract;
import com.jerry.mekmm.common.tile.TileEntityWirelessTransmissionStation;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.button.PacketTileButtonPress;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiWirelessTransmissionStationConfig
extends GuiConnectListHolder<TileEntityWirelessTransmissionStation, MekanismTileContainer<TileEntityWirelessTransmissionStation>> {
    private GuiTextField energyRateField;
    private GuiTextField fluidsRateField;
    private GuiTextField chemicalsRateField;
    private GuiTextField itemsRateField;

    public GuiWirelessTransmissionStationConfig(MekanismTileContainer<TileEntityWirelessTransmissionStation> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        ((MekanismImageButton)this.addRenderableWidget((GuiElement)new MekanismImageButton((IGuiWrapper)this, 5, 5, 11, 14, this.getButtonLocation("back"), (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketTileButtonPress(PacketTileButtonPress.ClickedTileButton.BACK_BUTTON, (BlockEntity)((GuiWirelessTransmissionStationConfig)element.gui()).tile))))).setTooltip(TooltipUtils.BACK);
        this.energyRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 45, 60, 11));
        this.energyRateField.setMaxLength(Long.toString(MoreMachineConfig.general.energyRate.get()).length());
        this.energyRateField.setInputValidator(InputValidator.DIGIT);
        this.energyRateField.configureDigitalBorderInput(() -> this.setText(this.energyRateField, MoreMachinePacketGuiInteract.MMGuiInteraction.SET_ENERGY_RATE));
        this.fluidsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 71, 60, 11));
        this.fluidsRateField.setMaxLength(Integer.toString(MoreMachineConfig.general.fluidsRate.get()).length());
        this.fluidsRateField.setInputValidator(InputValidator.DIGIT);
        this.fluidsRateField.configureDigitalBorderInput(() -> this.setText(this.fluidsRateField, MoreMachinePacketGuiInteract.MMGuiInteraction.SET_FLUIDS_RATE));
        this.chemicalsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 98, 60, 11));
        this.chemicalsRateField.setMaxLength(Long.toString(MoreMachineConfig.general.chemicalsRate.get()).length());
        this.chemicalsRateField.setInputValidator(InputValidator.DIGIT);
        this.chemicalsRateField.configureDigitalBorderInput(() -> this.setText(this.chemicalsRateField, MoreMachinePacketGuiInteract.MMGuiInteraction.SET_CHEMICALS_RATE));
        this.itemsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 125, 60, 11));
        this.itemsRateField.setMaxLength(Integer.toString(MoreMachineConfig.general.itemsRate.get()).length());
        this.itemsRateField.setInputValidator(InputValidator.DIGIT);
        this.itemsRateField.configureDigitalBorderInput(() -> this.setText(this.itemsRateField, MoreMachinePacketGuiInteract.MMGuiInteraction.SET_ITEMS_RATE));
    }

    protected void addGenericTabs() {
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.renderTitleTextWithOffset(guiGraphics, 14);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_ENERGY_RATE.translate(new Object[]{EnergyDisplay.of((long)((TileEntityWirelessTransmissionStation)this.tile).getEnergyRate())}), 18);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_FLUIDS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getFluidsRate()}), 44);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_CHEMICALS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getChemicalsRate()}), 71);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_ITEMS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getItemsRate()}), 99);
    }

    @Override
    protected void onClick(ConnectionConfig config, int index) {
        this.addWindow(GuiViewConnection.create((IGuiWrapper)this, (TileEntityWirelessTransmissionStation)this.tile, this.level, config));
    }

    private void setText(GuiTextField field, MoreMachinePacketGuiInteract.MMGuiInteraction interaction) {
        if (!field.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer((CustomPacketPayload)new MoreMachinePacketGuiInteract(interaction, (BlockEntity)this.tile, Integer.parseInt(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }
}

