/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui;

import com.jerry.mekmm.client.gui.element.button.ConnectListButton;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.attachments.component.WirelessConnectionManager;
import com.jerry.mekmm.common.tile.interfaces.ITileConnectHolder;
import java.util.Collections;
import java.util.List;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class GuiConnectListHolder<TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanismTile<TILE, CONTAINER> {
    private static final int CONNECT_COUNT = 5;
    protected GuiInnerScreen leftScreen;
    private GuiScrollBar scrollBar;
    Level level;

    protected GuiConnectListHolder(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
        this.level = inv.player.level();
        this.imageHeight += 95;
        this.imageWidth += 100;
        this.inventoryLabelX += 50;
        this.inventoryLabelY = this.imageHeight - 94;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.leftScreen = (GuiInnerScreen)this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 9, 17, 110, 147));
        this.addRenderableWidget((GuiElement)new GuiElementHolder((IGuiWrapper)this, 120, 17, 133, 147));
        WirelessConnectionManager connectionManager = this.getConnectManager();
        this.scrollBar = (GuiScrollBar)this.addRenderableWidget((GuiElement)new GuiScrollBar((IGuiWrapper)this, 253, 17, 147, connectionManager::getConnectionCount, () -> 5));
        for (int i = 0; i < 5; ++i) {
            this.addRenderableWidget((GuiElement)new ConnectListButton((IGuiWrapper)this, 121, 18 + i * 29, i, () -> ((GuiScrollBar)this.scrollBar).getCurrentSelection(), connectionManager, this::onClick, this::getRenderStacks, this.level));
        }
    }

    protected void drawScreenText(GuiGraphics guiGraphics, Component text, int y) {
        this.drawScreenText(guiGraphics, text, 0, y);
    }

    protected void drawScreenText(GuiGraphics guiGraphics, Component text, int x, int y) {
        if (this.leftScreen != null) {
            this.leftScreen.drawScaledScrollingString(guiGraphics, text, x, y, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), this.leftScreen.getXSize() - x, 5, false, 0.8f);
        }
    }

    private List<ItemStack> getRenderStacks(ConnectionConfig config) {
        if (config != null) {
            return List.of(this.level.getBlockState(config.pos()).getBlock().asItem().getDefaultInstance());
        }
        return Collections.emptyList();
    }

    protected WirelessConnectionManager getConnectManager() {
        return ((ITileConnectHolder)this.tile).getConnectManager();
    }

    protected abstract void onClick(ConnectionConfig var1, int var2);

    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta) || this.scrollBar.adjustScroll(yDelta);
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.renderInventoryText(guiGraphics);
    }
}

