/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import com.jerry.mekmm.api.recipes.FluidChemicalToFluidRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class BasicFluidChemicalToFluidRecipe
extends FluidChemicalToFluidRecipe {
    protected final FluidStackIngredient fluidInput;
    protected final ChemicalStackIngredient chemicalInput;
    protected final FluidStack output;

    public BasicFluidChemicalToFluidRecipe(FluidStackIngredient fluidInput, ChemicalStackIngredient chemicalInput, FluidStack output) {
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(FluidStack fluidStack, ChemicalStack chemicalStack) {
        return this.fluidInput.test(fluidStack) && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Override
    public List<FluidStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public FluidStack getOutput(FluidStack fluidStack, ChemicalStack chemicalStack) {
        return this.output.copy();
    }

    public FluidStack getOutputRaw() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicFluidChemicalToFluidRecipe other = (BasicFluidChemicalToFluidRecipe)o;
        return this.fluidInput.equals((Object)other.fluidInput) && this.chemicalInput.equals((Object)other.chemicalInput) && this.output.equals(other.output);
    }

    public int hashCode() {
        return Objects.hash(this.fluidInput, this.chemicalInput, this.output);
    }
}

