/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.datagen.recipe.builder;

import com.jerry.mekmm.api.recipes.basic.BasicPlantingRecipe;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

@NothingNullByDefault
public class PlantingStationRecipeBuilder
extends MekanismRecipeBuilder<PlantingStationRecipeBuilder> {
    private final ItemStackIngredient itemInput;
    private final ChemicalStackIngredient chemicalInput;
    private final ItemStack mainOutput;
    private final ItemStack secondaryOutput;
    private final boolean perTickUsage;

    protected PlantingStationRecipeBuilder(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack mainOutput, ItemStack secondaryOutput, boolean perTickUsage) {
        this.itemInput = itemInput;
        this.chemicalInput = chemicalInput;
        this.mainOutput = mainOutput;
        this.secondaryOutput = secondaryOutput;
        this.perTickUsage = perTickUsage;
    }

    public static PlantingStationRecipeBuilder planting(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack mainOutput, boolean perTickUsage) {
        if (mainOutput.isEmpty()) {
            throw new IllegalArgumentException("This planting recipe requires a non empty output.");
        }
        return new PlantingStationRecipeBuilder(itemInput, chemicalInput, mainOutput, ItemStack.EMPTY, perTickUsage);
    }

    public static PlantingStationRecipeBuilder planting(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack mainOutput, ItemStack secondaryOutput, boolean perTickUsage) {
        if (mainOutput.isEmpty() || secondaryOutput.isEmpty()) {
            throw new IllegalArgumentException("This planting recipe requires a non empty primary, and secondary output.");
        }
        return new PlantingStationRecipeBuilder(itemInput, chemicalInput, mainOutput, secondaryOutput, perTickUsage);
    }

    protected Recipe<?> asRecipe() {
        return new BasicPlantingRecipe(this.itemInput, this.chemicalInput, this.mainOutput, this.secondaryOutput, this.perTickUsage);
    }
}

