/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.generator;

import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.tile.prefab.TileEntityMoreMachineGenerator;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeGasGenerator
extends TileEntityMoreMachineGenerator
implements IBoundingBlock {
    public static final Predicate<ChemicalStack> HAS_FUEL = chemical -> chemical.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel()) != null || chemical.hasLegacy(ChemicalAttributes.Fuel.class);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getFuel", "getFuelCapacity", "getFuelNeeded", "getFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public FuelTank fuelTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel item slot")
    ChemicalInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;
    private long burnTicks;
    private int maxBurnTicks;
    private long generationRate = 0L;
    private double gasUsedLastTick;
    private double efficiencyMultiplier = 1.0;
    private int numPowering;

    public TileEntityLargeGasGenerator(BlockPos pos, BlockState state) {
        super((Holder<Block>)LargeMachineBlocks.LARGE_GAS_BURNING_GENERATOR, pos, state, ChemicalUtil::hydrogenEnergyPerTick);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide((Supplier)this.facingSupplier);
        this.fuelTank = new FuelTank(listener);
        builder.addTank((IChemicalTank)this.fuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        this.fuelSlot = ChemicalInventorySlot.fill((IChemicalTank)this.fuelTank, (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.RIGHT});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.TOP});
        this.fuelSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.TOP};
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillTank();
        this.updateEfficiency();
        if (!this.fuelTank.isEmpty() && this.canFunction() && this.getEnergyContainer().insert(this.generationRate, Action.SIMULATE, AutomationType.INTERNAL) == 0L) {
            ChemicalFuel fuel;
            this.setActive(true);
            if (!this.fuelTank.isEmpty() && (fuel = this.fuelTank.getFuel()) != null) {
                this.maxBurnTicks = Math.max(1, fuel.burnTicks());
                this.generationRate = fuel.energyPerTick();
            }
            long toUse = (long)((double)this.getToUse() * this.efficiencyMultiplier);
            long toUseGeneration = MathUtils.multiplyClamped((long)((long)((double)this.generationRate * this.efficiencyMultiplier)), (long)toUse);
            this.updateMaxOutputRaw(Math.max(ChemicalUtil.hydrogenEnergyPerTick(), toUseGeneration));
            long total = this.burnTicks + this.fuelTank.getStored() * (long)this.maxBurnTicks;
            total -= toUse;
            this.getEnergyContainer().insert(toUseGeneration, Action.EXECUTE, AutomationType.INTERNAL);
            if (!this.fuelTank.isEmpty()) {
                this.fuelTank.setStack(this.fuelTank.getStack().copyWithAmount(total / (long)this.maxBurnTicks));
            }
            this.burnTicks = total % (long)this.maxBurnTicks;
            this.gasUsedLastTick = (double)toUse / (double)this.maxBurnTicks;
        } else {
            if (this.fuelTank.isEmpty() && this.burnTicks == 0L) {
                this.reset();
            }
            this.gasUsedLastTick = 0.0;
            this.setActive(false);
        }
        return sendUpdatePacket;
    }

    @Override
    protected BlockPos offSetOutput(BlockPos from, Direction side) {
        return from.offset(new Vec3i(0, 2, 0)).relative(side);
    }

    private void reset() {
        this.burnTicks = 0L;
        this.maxBurnTicks = 0;
        this.generationRate = 0L;
        this.updateMaxOutputRaw(ChemicalUtil.hydrogenEnergyPerTick());
    }

    private long getToUse() {
        if (this.generationRate == 0L || this.fuelTank.isEmpty()) {
            return 0L;
        }
        long max = (long)Math.ceil(256.0 * ((double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity()));
        max = Math.min((long)this.maxBurnTicks * this.fuelTank.getStored() + this.burnTicks, max);
        max = Math.min(MathUtils.clampToLong((double)((double)this.getEnergyContainer().getNeeded() / (double)this.generationRate)), max);
        return max;
    }

    @ComputerMethod(nameOverride="getEfficiencyMultiplier")
    public double getEfficiencyMultiplier() {
        return (double)Math.round(this.efficiencyMultiplier * 100.0) / 100.0;
    }

    @ComputerMethod(nameOverride="getBurnRate")
    public double getUsed() {
        return (double)Math.round(this.gasUsedLastTick * this.efficiencyMultiplier * 100.0) / 100.0;
    }

    private void updateEfficiency() {
        if (this.fuelTank.isEmpty()) {
            this.efficiencyMultiplier = 1.0;
            return;
        }
        double fillPercentage = (double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity();
        this.efficiencyMultiplier = 1.0 + 21.0 * Math.pow(fillPercentage, 3.0);
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableLong.create(this::getGenerationRate, value -> {
            this.generationRate = value;
        }));
        container.track(this.syncableMaxOutput());
        container.track((ISyncableData)SyncableDouble.create(this::getUsed, value -> {
            this.gasUsedLastTick = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getMaxBurnTicks, value -> {
            this.maxBurnTicks = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.getStepX(), 0, left.getStepZ())) || offset.equals((Object)new Vec3i(left.getStepX(), 1, left.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction right = left.getOpposite();
        if (offset.equals((Object)new Vec3i(right.getStepX(), 0, right.getStepZ())) || offset.equals((Object)new Vec3i(right.getStepX(), 1, right.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ENERGY.block()) {
            return (T)Objects.requireNonNull(this.energyHandlerManager, "Expected to have energy handler").resolve(capability, side);
        }
        if (capability == Capabilities.CHEMICAL.block()) {
            return (T)Objects.requireNonNull(this.chemicalHandlerManager, "Expected to have chemical handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return this.notChemicalPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        return this.notChemicalPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notChemicalPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ()))) {
            return side != back;
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.getStepX(), 0, left.getStepZ())) || offset.equals((Object)new Vec3i(left.getStepX(), 1, left.getStepZ()))) {
            return side != left;
        }
        Direction right = left.getOpposite();
        if (offset.equals((Object)new Vec3i(right.getStepX(), 0, right.getStepZ())) || offset.equals((Object)new Vec3i(right.getStepX(), 1, right.getStepZ()))) {
            return side != right;
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notChemicalPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)new Vec3i(0, 2, 0))) {
            return side != Direction.UP;
        }
        return true;
    }

    @Override
    protected long getProductionRate() {
        return MathUtils.clampToLong((double)((double)this.getGenerationRate() * this.getUsed() * (double)this.getMaxBurnTicks()));
    }

    @Generated
    public int getMaxBurnTicks() {
        return this.maxBurnTicks;
    }

    @Generated
    public long getGenerationRate() {
        return this.generationRate;
    }

    public class FuelTank
    extends VariableCapacityChemicalTank {
        protected FuelTank(IContentsListener listener) {
            super((LongSupplier)MoreMachineConfig.generators.LGBGTankCapacity, ConstantPredicates.notExternal(), ConstantPredicates.alwaysTrueBi(), HAS_FUEL, null, listener);
        }

        public void setStack(@NotNull ChemicalStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStack(stack);
            this.recheckOutput(stack, wasEmpty);
        }

        public void setStackUnchecked(@NotNull ChemicalStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStackUnchecked(stack);
            this.recheckOutput(stack, wasEmpty);
        }

        private void recheckOutput(@NotNull ChemicalStack stack, boolean wasEmpty) {
            ChemicalFuel fuel;
            if (wasEmpty && !stack.isEmpty() && (fuel = this.getFuel()) != null) {
                TileEntityLargeGasGenerator.this.updateMaxOutputRaw(fuel.energyPerTick());
            }
        }

        @Nullable
        public ChemicalFuel getFuel() {
            ChemicalAttributes.Fuel legacyFuel;
            if (this.isEmpty()) {
                return null;
            }
            ChemicalStack stack = this.getStack();
            ChemicalFuel fuel = (ChemicalFuel)stack.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel());
            if (fuel == null && (legacyFuel = (ChemicalAttributes.Fuel)stack.getLegacy(ChemicalAttributes.Fuel.class)) != null) {
                return legacyFuel.asModern();
            }
            return fuel;
        }
    }
}

