/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityAdvancedFactoryBase<RECIPE extends MekanismRecipe<?>>
extends TileEntityConfigurableMachine
implements IRecipeLookupHandler<RECIPE> {
    protected static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_CHEMICAL = 10000L;
    public static final int MAX_FLUID = 10000;
    protected FactoryRecipeCacheLookupMonitor<RECIPE>[] recipeCacheLookupMonitors;
    protected BooleanSupplier[] recheckAllRecipeErrors;
    protected final ErrorTracker errorTracker;
    private final boolean[] activeStates;
    public FactoryTier tier;
    public final int[] progress;
    private int ticksRequired = 200;
    private int operationsPerTick = 1;
    protected boolean sorting;
    private boolean sortingNeeded = true;
    private long lastUsage = 0L;
    @NotNull
    protected final AdvancedFactoryType type;
    protected AdvancedFactoryEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    protected IInputHandler<@NotNull ChemicalStack>[] chemicalInputHandlers;
    protected IOutputHandler<@NotNull ChemicalStack>[] chemicalOutputHandlers;
    protected IInputHandler<@NotNull ItemStack>[] itemInputHandlers;
    protected IOutputHandler<@NotNull ItemStack>[] itemOutputHandlers;
    protected IInputHandler<@NotNull FluidStack>[] fluidInputHandlers;
    protected IOutputHandler<@NotNull FluidStack>[] fluidOutputHandlers;

    protected TileEntityAdvancedFactoryBase(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state);
        this.type = ((AttributeAdvancedFactoryType)Attribute.getOrThrow(blockProvider, AttributeAdvancedFactoryType.class)).getAdvancedFactoryType();
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, (Object)this.energyContainer);
        this.progress = new int[this.tier.processes];
        this.activeStates = new boolean[this.tier.processes];
        this.recheckAllRecipeErrors = new BooleanSupplier[this.tier.processes];
        for (int i = 0; i < this.recheckAllRecipeErrors.length; ++i) {
            this.recheckAllRecipeErrors[i] = TileEntityRecipeMachine.shouldRecheckAllErrors((TileEntityMekanism)this);
        }
        this.errorTracker = new ErrorTracker(errorTypes, globalErrorTypes, this.tier.processes);
    }

    protected IContentsListener markAllMonitorsChanged(IContentsListener listener) {
        return () -> {
            listener.onContentsChanged();
            for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
                cacheLookupMonitor.onChange();
            }
        };
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = (FactoryTier)Attribute.getTier((Holder)this.getBlockHolder(), FactoryTier.class);
        Runnable setSortingNeeded = () -> {
            this.sortingNeeded = true;
        };
        this.recipeCacheLookupMonitors = new FactoryRecipeCacheLookupMonitor[this.tier.processes];
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            this.recipeCacheLookupMonitors[i] = new FactoryRecipeCacheLookupMonitor((IRecipeLookupHandler)this, i, setSortingNeeded);
        }
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.addTanks(builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = AdvancedFactoryEnergyContainer.input(this, () -> {
            listener.onContentsChanged();
            for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
                cacheLookupMonitor.unpause();
            }
        });
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.addSlots(builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        this.energySlot = EnergyInventorySlot.fillOrConvert((IEnergyContainer)this.energyContainer, () -> ((TileEntityAdvancedFactoryBase)this).getLevel(), (IContentsListener)listener, (int)7, (int)13);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected abstract void addTanks(ChemicalTankHelper var1, IContentsListener var2, IContentsListener var3);

    protected abstract void addSlots(InventorySlotHelper var1, IContentsListener var2, IContentsListener var3);

    public int getXPos(int index) {
        int baseX;
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        return baseX + index * baseXMult;
    }

    public IChemicalTank getChemicalTankBar() {
        return null;
    }

    @Nullable
    protected IInventorySlot getExtraSlot() {
        return null;
    }

    public AdvancedFactoryType getAdvancedFactoryType() {
        return this.type;
    }

    public long getRecipeEnergyRequired() {
        return 0L;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.handleSecondaryFuel();
        if (this.sortingNeeded && this.isSorting()) {
            this.sortingNeeded = false;
            this.sortInventoryOrTank();
        } else if (!this.sortingNeeded && CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.sortingNeeded = true;
        }
        long prev = this.energyContainer.getEnergy();
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            if (this.recipeCacheLookupMonitors[i].updateAndProcess()) continue;
            this.activeStates[i] = false;
        }
        boolean isActive = false;
        for (boolean state : this.activeStates) {
            if (!state) continue;
            isActive = true;
            break;
        }
        this.setActive(isActive);
        this.lastUsage = isActive ? prev - this.energyContainer.getEnergy() : 0L;
        return sendUpdatePacket;
    }

    @Nullable
    protected CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.recipeCacheLookupMonitors[cacheIndex].getCachedRecipe(cacheIndex);
    }

    public BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
        return this.errorTracker.getWarningCheck(error, processIndex);
    }

    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.errorTracker.trackedErrors[cacheIndex], false);
    }

    protected void setActiveState(boolean state, int cacheIndex) {
        this.activeStates[cacheIndex] = state;
    }

    protected void handleSecondaryFuel() {
    }

    public int getProgress(int cacheIndex) {
        return this.progress[cacheIndex];
    }

    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getProgress(cacheIndex);
    }

    public double getScaledProgress(int i, int process) {
        return (double)this.getProgress(process) * (double)i / (double)this.ticksRequired;
    }

    public void toggleSorting() {
        this.sorting = !this.isSorting();
        this.markForSave();
    }

    @ComputerMethod(nameOverride="isAutoSortEnabled")
    public boolean isSorting() {
        return this.sorting;
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getLastUsage() {
        return this.lastUsage;
    }

    @ComputerMethod(methodDescription="Total number of ticks it takes currently for the recipe to complete")
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public int getOperationsPerTick() {
        return this.operationsPerTick;
    }

    public void setTicksRequired(int value) {
        this.ticksRequired = value;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("progress", 11)) {
            int[] savedProgress = nbt.getIntArray("progress");
            if (this.tier.processes != savedProgress.length) {
                Arrays.fill(this.progress, 0);
            }
            for (int i = 0; i < this.tier.processes && i < savedProgress.length; ++i) {
                this.progress[i] = savedProgress[i];
            }
        }
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putIntArray("progress", Arrays.copyOf(this.progress, this.progress.length));
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        data.putBoolean("sorting", this.isSorting());
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"sorting", value -> {
            this.sorting = value;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.SORTING, (Object)this.isSorting());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.sorting = (Boolean)input.getOrDefault((Supplier)MekanismDataComponents.SORTING, (Object)this.sorting);
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)200);
            this.operationsPerTick = MekanismUtils.getOperationsPerTick((IUpgradeTile)this, (int)200, (int)1);
        }
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public boolean isConfigurationDataCompatible(Block blockType) {
        return super.isConfigurationDataCompatible(blockType) || MoreMachineUtils.isSameAFTypeFactory((Holder<Block>)this.getBlockHolder(), blockType);
    }

    public boolean hasExtraResourceBar() {
        return false;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.progress);
        this.errorTracker.track(container);
        container.track((ISyncableData)SyncableLong.create(this::getLastUsage, value -> {
            this.lastUsage = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isSorting, value -> {
            this.sorting = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
    }

    protected void validateValidProcess(int process) throws ComputerException {
        if (process < 0 || process >= this.progress.length) {
            throw new ComputerException("Process: '%d' is out of bounds, as this factory only has '%d' processes (zero indexed).", new Object[]{process, this.progress.length});
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setAutoSort(boolean enabled) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.sorting != enabled) {
            this.sorting = enabled;
            this.markForSave();
        }
    }

    @ComputerMethod
    int getRecipeProgress(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.getProgress(process);
    }

    protected abstract void sortInventoryOrTank();

    @Generated
    public AdvancedFactoryEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    protected static class ErrorTracker {
        private final List<CachedRecipe.OperationTracker.RecipeError> errorTypes;
        private final IntSet globalTypes;
        private final boolean[][] trackedErrors;
        private final int processes;

        public ErrorTracker(List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes, int processes) {
            this.errorTypes = List.copyOf(errorTypes);
            this.globalTypes = new IntArraySet(globalErrorTypes.size());
            for (int i = 0; i < this.errorTypes.size(); ++i) {
                CachedRecipe.OperationTracker.RecipeError error = this.errorTypes.get(i);
                if (!globalErrorTypes.contains(error)) continue;
                this.globalTypes.add(i);
            }
            this.processes = processes;
            this.trackedErrors = new boolean[this.processes][];
            int errors = this.errorTypes.size();
            for (int i = 0; i < this.trackedErrors.length; ++i) {
                this.trackedErrors[i] = new boolean[errors];
            }
        }

        private void track(MekanismContainer container) {
            container.trackArray(this.trackedErrors);
        }

        public void onErrorsChanged(Set<CachedRecipe.OperationTracker.RecipeError> errors, int processIndex) {
            boolean[] processTrackedErrors = this.trackedErrors[processIndex];
            for (int i = 0; i < processTrackedErrors.length; ++i) {
                processTrackedErrors[i] = errors.contains(this.errorTypes.get(i));
            }
        }

        private BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
            int errorIndex;
            if (processIndex >= 0 && processIndex < this.processes && (errorIndex = this.errorTypes.indexOf(error)) >= 0) {
                if (this.globalTypes.contains(errorIndex)) {
                    return () -> {
                        for (boolean[] tracked : this.trackedErrors) {
                            if (!tracked[errorIndex]) continue;
                            return true;
                        }
                        return false;
                    };
                }
                return () -> this.trackedErrors[processIndex][errorIndex];
            }
            return () -> false;
        }
    }
}

