/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.imp;

import com.jerry.datagen.common.recipe.BaseRecipeProvider;
import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import com.jerry.datagen.common.recipe.builder.ExtendedShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.builder.MoreMachineDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.compat.EMAdvancedFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.compat.EMMoreMachineRecipeProvider;
import com.jerry.datagen.common.recipe.compat.IERecipeProvider;
import com.jerry.datagen.common.recipe.compat.MysticalRecipeProvider;
import com.jerry.datagen.common.recipe.imp.AdvancedFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.imp.MMFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.imp.PlantingRecipeProvider;
import com.jerry.datagen.common.recipe.pattern.RecipePattern;
import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.tags.MekanismTags;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@NothingNullByDefault
public class MoreMachineRecipeProvider
extends BaseRecipeProvider {
    static final char DIAMOND_CHAR = 'D';
    static final char GLASS_CHAR = 'G';
    static final char PERSONAL_STORAGE_CHAR = 'P';
    static final char MIXING_CHAR = 'M';
    static final char ROBIT_CHAR = 'R';
    static final char SORTER_CHAR = 'S';
    static final char TELEPORTATION_CORE_CHAR = 'T';
    public static final RecipePattern TIER_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('I', 'P', 'I'), RecipePattern.TripleLine.of('A', 'C', 'A'));
    static final RecipePattern STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    static final RecipePattern TYPED_STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', 'P', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    public static final RecipePattern BASIC_MODULE = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('A', 'P', 'A'), RecipePattern.TripleLine.of('H', 'H', 'H'));
    private final List<ISubRecipeProvider> compatProviders = new ArrayList<ISubRecipeProvider>();
    private final Set<String> disabledCompats = new HashSet<String>();

    public MoreMachineRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        super(output, provider, existingFileHelper);
        this.checkCompat("mysticalagriculture", MysticalRecipeProvider::new);
        this.checkCompat("immersiveengineering", IERecipeProvider::new);
        this.checkCompat("evolvedmekanism", EMMoreMachineRecipeProvider::new);
        this.checkCompat("evolvedmekanism", EMAdvancedFactoryRecipeProvider::new);
    }

    private void checkCompat(String modid, Function<String, ISubRecipeProvider> providerCreator) {
        if (ModList.get().isLoaded(modid)) {
            this.compatProviders.add(providerCreator.apply(modid));
        } else {
            this.disabledCompats.add(modid);
        }
    }

    public Set<String> getDisabledCompats() {
        return Collections.unmodifiableSet(this.disabledCompats);
    }

    @Override
    protected void addRecipes(RecipeOutput consumer, HolderLookup.Provider registries) {
        this.addMiscRecipes(consumer);
        this.addGearModuleRecipes(consumer);
        this.addLateGameRecipes(consumer);
        for (ISubRecipeProvider compatProvider : this.compatProviders) {
            compatProvider.addRecipes(consumer, registries);
        }
    }

    @Override
    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return List.of(new MMFactoryRecipeProvider(), new AdvancedFactoryRecipeProvider(), new PlantingRecipeProvider());
    }

    private void addMiscRecipes(RecipeOutput consumer) {
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineItems.ADVANCED_ELECTROLYSIS_CORE).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'E', 'A'), RecipePattern.TripleLine.of('B', 'D', 'C'), RecipePattern.TripleLine.of('A', 'E', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ULTIMATE).key('B', (TagKey<Item>)MekanismTags.Items.DUSTS_LAPIS).key('C', (TagKey<Item>)MekanismTags.Items.DUSTS_DIAMOND).key('D', (TagKey<Item>)MekanismTags.Items.DUSTS_NETHERITE).key('E', (ItemLike)MekanismItems.ELECTROLYTIC_CORE).build(consumer, Mekmm.rl("advanced_electrolysis_core"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.RECYCLER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('O', '#', 'O'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ADVANCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ADVANCED).key('O', MoreMachineRecipeProvider.osmiumIngot()).key('#', (ItemLike)MekanismBlocks.CRUSHER).build(consumer, Mekmm.rl("recycler"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.PLANTING_STATION).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_REINFORCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ELITE).key('#', (ItemLike)MekanismItems.BIO_FUEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("planting_station"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_STAMPER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON, Items.STICKY_PISTON})).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_stamper"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_LATHE).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', (ItemLike)MekanismItems.ROBIT).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_lathe"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_ROLLING_MILL).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('S', 'X', 'S'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('S', (TagKey<Item>)MekanismTags.Items.INGOTS_STEEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_rolling_mill"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_ROTARY_CONDENSENTRATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('B', 'C', 'B'), RecipePattern.TripleLine.of('T', 'R', 'W'), RecipePattern.TripleLine.of('B', 'C', 'B'))).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('T', (ItemLike)LargeMachineBlocks.ULTIMATE_MAX_CHEMICAL_TANK).key('R', (ItemLike)MekanismItems.ROBIT).key('W', (ItemLike)MekanismBlocks.ULTIMATE_FLUID_TANK).build(consumer, Mekmm.rl("large_rotary_condensentrator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_CHEMICAL_INFUSER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('B', 'C', 'B'), RecipePattern.TripleLine.of('T', 'R', 'T'), RecipePattern.TripleLine.of('B', 'C', 'B'))).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('T', (ItemLike)LargeMachineBlocks.ULTIMATE_MAX_CHEMICAL_TANK).key('R', (ItemLike)MekanismItems.ROBIT).build(consumer, Mekmm.rl("large_chemical_infuser"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_ELECTROLYTIC_SEPARATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('B', 'E', 'B'), RecipePattern.TripleLine.of('W', 'R', 'T'), RecipePattern.TripleLine.of('B', 'E', 'B'))).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('E', (ItemLike)MoreMachineItems.ADVANCED_ELECTROLYSIS_CORE).key('W', (ItemLike)MekanismBlocks.ULTIMATE_FLUID_TANK).key('R', (ItemLike)MekanismItems.ROBIT).key('T', (ItemLike)LargeMachineBlocks.ULTIMATE_MAX_CHEMICAL_TANK).build(consumer, Mekmm.rl("large_electrolytic_separator"));
        ((ExtendedShapedRecipeBuilder)MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_SOLAR_NEUTRON_ACTIVATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('S', 'S', 'S'), RecipePattern.TripleLine.of('B', 'R', 'B'), RecipePattern.TripleLine.of('T', 'L', 'T'))).key('S', (ItemLike)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('R', (ItemLike)MekanismItems.ROBIT).key('T', (ItemLike)LargeMachineBlocks.ULTIMATE_MAX_CHEMICAL_TANK).key('L', (ItemLike)MekanismBlocks.LASER).addCondition((ICondition)new ModLoadedCondition("mekanismgenerators"))).build(consumer, Mekmm.rl("large_solar_neutron_activator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_HEAT_GENERATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('B', 'S', 'B'), RecipePattern.TripleLine.of('T', 'R', 'T'), RecipePattern.TripleLine.of('B', 'S', 'B'))).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('S', (ItemLike)MekanismBlocks.SUPERHEATING_ELEMENT).key('T', (ItemLike)MekanismBlocks.ULTIMATE_FLUID_TANK).key('R', (ItemLike)MekanismItems.ROBIT).build(consumer, Mekmm.rl("large_heat_generator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(LargeMachineBlocks.LARGE_GAS_BURNING_GENERATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('T', 'E', 'T'), RecipePattern.TripleLine.of('B', 'R', 'B'), RecipePattern.TripleLine.of('T', 'E', 'T'))).key('T', (ItemLike)LargeMachineBlocks.ULTIMATE_MAX_CHEMICAL_TANK).key('E', (ItemLike)MoreMachineItems.ADVANCED_ELECTROLYSIS_CORE).key('B', (TagKey<Item>)MekanismTags.Items.STORAGE_BLOCKS_STEEL).key('R', (ItemLike)MekanismItems.ROBIT).build(consumer, Mekmm.rl("large_gas_burning_generator"));
    }

    private void addGearModuleRecipes(RecipeOutput consumer) {
    }

    private void addLateGameRecipes(RecipeOutput consumer) {
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'S', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MoreMachineItems.UU_MATTER).key('S', (TagKey<Item>)Tags.Items.CHESTS).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("replicator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.FLUID_REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'B', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MoreMachineItems.UU_MATTER).key('B', (ItemLike)Items.BUCKET).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("fluid_replicator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CHEMICAL_REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'T', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MoreMachineItems.UU_MATTER).key('T', (ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("chemical_replicator"));
        ExtendedShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.AMBIENT_GAS_COLLECTOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('T', 'X', 'T'), RecipePattern.TripleLine.of('O', 'O', 'O'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('#', (ItemLike)MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE).key('T', (ItemLike)MekanismBlocks.ULTIMATE_CHEMICAL_TANK).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).key('O', (TagKey<Item>)((TagKey)MekanismTags.Items.PROCESSED_RESOURCE_BLOCKS.get(PrimaryResource.OSMIUM))).build(consumer, Mekmm.rl("ambient_gas_collector"));
        ExtendedShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.WIRELESS_CHARGING_STATION).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('H', '#', 'H'), RecipePattern.TripleLine.of('H', 'R', 'H'), RecipePattern.TripleLine.of('C', 'E', 'C'))).key('H', (ItemLike)MekanismItems.HDPE_SHEET).key('#', (ItemLike)MekanismItems.TELEPORTATION_CORE).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('R', (ItemLike)MekanismItems.ROBIT).key('E', (ItemLike)MekanismBlocks.ULTIMATE_ENERGY_CUBE).build(consumer, Mekmm.rl("wireless_charging_station"));
        ExtendedShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.WIRELESS_TRANSMISSION_STATION).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('H', '#', 'H'), RecipePattern.TripleLine.of('H', 'R', 'H'), RecipePattern.TripleLine.of('P', 'Q', 'P'))).key('H', (ItemLike)MekanismItems.HDPE_SHEET).key('#', (ItemLike)MekanismBlocks.SUPERCHARGED_COIL).key('P', (TagKey<Item>)MekanismTags.Items.PELLETS_PLUTONIUM).key('R', (ItemLike)MekanismItems.ROBIT).key('Q', (ItemLike)MekanismBlocks.QUANTUM_ENTANGLOPORTER).build(consumer, Mekmm.rl("wireless_transmission_station"));
    }
}

