/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.compat;

import com.jerry.datagen.common.recipe.builder.ExtendedShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.builder.MoreMachineDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.compat.CompatRecipeProvider;
import com.jerry.datagen.common.recipe.imp.MoreMachineRecipeProvider;
import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.block.prefab.BlockAdvancedFactoryMachine;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.item.block.machine.ItemBlockAdvancedFactory;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlocks;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import fr.iglee42.evolvedmekanism.registries.EMTags;
import fr.iglee42.evolvedmekanism.tiers.EMFactoryTier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

@NothingNullByDefault
public class EMAdvancedFactoryRecipeProvider
extends CompatRecipeProvider {
    public EMAdvancedFactoryRecipeProvider(String modId) {
        super(modId, new String[0]);
    }

    @Override
    protected void registerRecipes(RecipeOutput consumer, String basePath, HolderLookup.Provider registries) {
        basePath = (String)basePath + "factory/";
        String overclockedPath = (String)basePath + "overclocked/";
        String quantumPath = (String)basePath + "quantum/";
        String densePath = (String)basePath + "dense/";
        String multiversalPath = (String)basePath + "multiversal/";
        String creativePath = (String)basePath + "creative/";
        TagKey uraniumIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.URANIUM);
        TagKey tinIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.TIN);
        for (AdvancedFactoryType type : MoreMachineEnumUtils.ADVANCED_FACTORY_TYPES) {
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> ultimateFactory = AdvancedFactoryBlocks.getAdvancedFactory(FactoryTier.ULTIMATE, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> overclockedFactory = AdvancedFactoryBlocks.getAdvancedFactory(EMFactoryTier.OVERCLOCKED, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> quantumFactory = AdvancedFactoryBlocks.getAdvancedFactory(EMFactoryTier.QUANTUM, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> denseFactory = AdvancedFactoryBlocks.getAdvancedFactory(EMFactoryTier.DENSE, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> multiversalFactory = AdvancedFactoryBlocks.getAdvancedFactory(EMFactoryTier.MULTIVERSAL, type);
            this.addFactoryRecipe(consumer, overclockedPath, overclockedFactory, (Holder<Item>)ultimateFactory.getItemHolder(), (TagKey<Item>)uraniumIngot, (TagKey<Item>)EMTags.Items.ALLOYS_OVERCLOCKED, (TagKey<Item>)EMTags.Items.CIRCUITS_OVERCLOCKED);
            this.addFactoryRecipe(consumer, quantumPath, quantumFactory, (Holder<Item>)overclockedFactory.getItemHolder(), (TagKey<Item>)tinIngot, (TagKey<Item>)EMTags.Items.ALLOYS_QUANTUM, (TagKey<Item>)EMTags.Items.CIRCUITS_QUANTUM);
            this.addFactoryRecipe(consumer, densePath, denseFactory, (Holder<Item>)quantumFactory.getItemHolder(), (TagKey<Item>)MekanismTags.Items.INGOTS_BRONZE, (TagKey<Item>)EMTags.Items.ALLOYS_DENSE, (TagKey<Item>)EMTags.Items.CIRCUITS_DENSE);
            this.addFactoryRecipe(consumer, multiversalPath, multiversalFactory, (Holder<Item>)denseFactory.getItemHolder(), (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (TagKey<Item>)EMTags.Items.ALLOYS_MULTIVERSAL, (TagKey<Item>)EMTags.Items.CIRCUITS_MULTIVERSAL);
            this.addFactoryRecipe(consumer, creativePath, AdvancedFactoryBlocks.getAdvancedFactory(EMFactoryTier.CREATIVE, type), (Holder<Item>)multiversalFactory.getItemHolder(), (TagKey<Item>)Tags.Items.NETHER_STARS, (TagKey<Item>)EMTags.Items.ALLOYS_CREATIVE, (TagKey<Item>)EMTags.Items.CIRCUITS_CREATIVE_FORGE);
        }
    }

    private void addFactoryRecipe(RecipeOutput consumer, String basePath, BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ?> factory, Holder<Item> toUpgrade, TagKey<Item> ingotTag, TagKey<Item> alloyTag, TagKey<Item> circuitTag) {
        ((ExtendedShapedRecipeBuilder)MoreMachineDataShapedRecipeBuilder.shapedRecipe(factory).pattern(MoreMachineRecipeProvider.TIER_PATTERN).key('P', (ItemLike)toUpgrade.value()).key('C', circuitTag).key('I', ingotTag).key('A', alloyTag).addCondition(this.modLoaded)).build(consumer, Mekmm.rl(basePath + ((AttributeAdvancedFactoryType)Attribute.get(factory, AttributeAdvancedFactoryType.class)).getAdvancedFactoryType().getRegistryNameComponent()));
    }
}

