/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.client.lang;

import com.jerry.datagen.client.lang.ConvertibleLanguageProvider;
import com.jerry.datagen.client.lang.FormatSplitter;
import com.jerry.datagen.client.lang.NonAmericanLanguageProvider;
import com.jerry.datagen.client.lang.UpsideDownLanguageProvider;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import mekanism.api.gear.ModuleData;
import mekanism.api.text.IHasTranslationKey;
import mekanism.client.recipe_viewer.alias.IAliasedTranslation;
import mekanism.common.advancements.MekanismAdvancement;
import mekanism.common.base.IModModule;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.MekanismDamageType;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.NotNull;

public abstract class BaseLanguageProvider
extends LanguageProvider {
    private final ConvertibleLanguageProvider[] altProviders;
    protected final String modName;
    protected final String basicModName;
    private final String modid;

    protected BaseLanguageProvider(PackOutput output, String modid) {
        this(output, modid, "Mekanism");
    }

    protected BaseLanguageProvider(PackOutput output, String modid, IModModule module) {
        this(output, modid, "Mekanism: " + module.getName());
    }

    private BaseLanguageProvider(PackOutput output, String modid, String modName) {
        super(output, modid, "en_us");
        this.modid = modid;
        this.modName = modName;
        this.basicModName = modName.replaceAll(":", "");
        this.altProviders = new ConvertibleLanguageProvider[]{new UpsideDownLanguageProvider(output, modid), new NonAmericanLanguageProvider(output, modid, "en_au"), new NonAmericanLanguageProvider(output, modid, "en_gb")};
    }

    protected void addPackData(IHasTranslationKey name, IHasTranslationKey packDescription) {
        this.add(name, this.modName);
        this.add(packDescription, "Resources used for " + this.modName);
    }

    protected void addModInfo(String description) {
        this.add("fml.menu.mods.info.description." + this.modid, description);
    }

    protected void addEntity(Holder<EntityType<?>> key, String value) {
        this.add(((EntityType)key.value()).getDescriptionId(), value);
    }

    protected void addModuleConfig(ResourceLocation configKey, String value) {
        this.add(configKey.toLanguageKey("module"), value);
    }

    protected void addHolder(Holder<? extends IHasTranslationKey> key, String value) {
        this.add((IHasTranslationKey)key.value(), value);
    }

    protected void add(IHasTranslationKey key, String value) {
        BlockRegistryObject blockHolder;
        if (key instanceof BlockRegistryObject && Attribute.matches((Holder)(blockHolder = (BlockRegistryObject)key), AttributeGui.class, attribute -> !attribute.hasCustomName())) {
            this.add(Util.makeDescriptionId((String)"container", (ResourceLocation)blockHolder.getId()), value);
        }
        this.add(key.getTranslationKey(), value);
    }

    protected void add(BlockRegistryObject<?, ?> blockRO, String value, String containerName) {
        if (!Attribute.matches(blockRO, AttributeGui.class, attribute -> !attribute.hasCustomName())) {
            throw new IllegalArgumentException(String.valueOf(blockRO) + " does not have a container name set.");
        }
        this.add(Util.makeDescriptionId((String)"container", (ResourceLocation)blockRO.getId()), containerName);
        this.add(blockRO.getTranslationKey(), value);
    }

    protected void add(Holder<ModuleData<?>> moduleDataProvider, String name, String description) {
        ModuleData moduleData = (ModuleData)moduleDataProvider.value();
        this.add(moduleData.getTranslationKey(), name);
        this.add(moduleData.getDescriptionTranslationKey(), description);
    }

    protected void addFluid(FluidRegistryObject<?, ?, ?, ?, ?> fluidRO, String name) {
        this.add((Block)fluidRO.getBlock(), name);
        this.add((IHasTranslationKey)fluidRO.getBucket(), name + " Bucket");
        this.add(ItemTags.create((ResourceLocation)Tags.Items.BUCKETS.location().withSuffix("/" + fluidRO.getName())), name + " Buckets");
    }

    protected void add(MekanismAdvancement advancement, String title, String description) {
        this.add(advancement.title(), title);
        this.add(advancement.description(), description);
    }

    protected void add(MekanismDamageType damageType, String value, String valueEscaping) {
        this.add((IHasTranslationKey)damageType, value);
        this.add(damageType.getTranslationKey() + ".player", valueEscaping);
    }

    private String getConfigSectionTranslationPath(IMekanismConfig config) {
        String baseConfigFolder = "Mekanism".toLowerCase(Locale.ROOT);
        String fileName = config.getFileName().replaceAll("[^a-zA-Z0-9]+", ".").toLowerCase(Locale.ROOT);
        return this.modid + ".configuration.section." + baseConfigFolder + "." + fileName + ".toml";
    }

    protected void addConfigs(Collection<IMekanismConfig> configs) {
        this.add(this.modid + ".configuration.title", this.modName + " Config");
        for (IMekanismConfig config : configs) {
            String key = this.getConfigSectionTranslationPath(config);
            this.add(key, config.getTranslation());
            this.add(key + ".title", this.modName + " - " + config.getTranslation());
        }
    }

    protected void addConfigs(IConfigTranslation ... translations) {
        for (IConfigTranslation translation : translations) {
            this.add((IHasTranslationKey)translation, translation.title());
            this.add(translation.getTranslationKey() + ".tooltip", translation.tooltip());
            String button = translation.button();
            if (button == null) continue;
            this.add(translation.getTranslationKey() + ".button", button);
        }
    }

    protected void addAliases(IAliasedTranslation ... translations) {
        for (IAliasedTranslation translation : translations) {
            this.add((IHasTranslationKey)translation, translation.getAlias());
        }
    }

    protected void addAlias(String path, String translation) {
        this.add(Util.makeDescriptionId((String)"alias", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path)), translation);
    }

    public void add(@NotNull String key, @NotNull String value) {
        if (value.contains("%s")) {
            throw new IllegalArgumentException("Values containing substitutions should use explicit numbered indices: " + key + " - " + value);
        }
        super.add(key, value);
        if (this.altProviders.length > 0) {
            List<FormatSplitter.Component> splitEnglish = FormatSplitter.split(value);
            for (ConvertibleLanguageProvider provider : this.altProviders) {
                provider.convert(key, value, splitEnglish);
            }
        }
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        CompletableFuture future = super.run(cache);
        if (this.altProviders.length > 0) {
            CompletableFuture[] futures = new CompletableFuture[this.altProviders.length + 1];
            futures[0] = future;
            for (int i = 0; i < this.altProviders.length; ++i) {
                futures[i + 1] = this.altProviders[i].run(cache);
            }
            return CompletableFuture.allOf(futures);
        }
        return future;
    }
}

