/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivemetalworks.util.TintedVertexBuilder;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;

public class TintedItemRenderTypeBuffer
implements MultiBufferSource {
    private static final Set<String> MAKE_TRANSPARENT = ImmutableSet.of((Object)"entity_solid", (Object)"entity_cutout", (Object)"entity_cutout_no_cull", (Object)"entity_translucent", (Object)"entity_no_outline");
    private final MultiBufferSource inner;
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public TintedItemRenderTypeBuffer(MultiBufferSource inner, int alpha, int temperature) {
        this.inner = inner;
        this.alpha = Mth.clamp((int)alpha, (int)0, (int)255);
        temperature = Mth.clamp((int)temperature, (int)0, (int)255);
        this.red = 255 - temperature * 79 / 255;
        this.green = 255 - temperature * 159 / 255;
        this.blue = 255 - temperature * 223 / 255;
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        if (this.alpha < 255 && MAKE_TRANSPARENT.contains(renderType.name) && renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType composite = (RenderType.CompositeRenderType)renderType;
            RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = composite.state.textureState;
            if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard textureState = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                ResourceLocation texture = textureState.texture.orElse(InventoryMenu.BLOCK_ATLAS);
                renderType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            }
        }
        return new TintedVertexBuilder(this.inner.getBuffer(renderType), this.red, this.green, this.blue, this.alpha);
    }
}

