/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class EntityMeltingRecipe
implements Recipe<RecipeInput> {
    public final ResourceLocation entity;
    public final List<FluidStack> result;

    public EntityMeltingRecipe(ResourceLocation entity, List<FluidStack> result) {
        this.entity = entity;
        this.result = result;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MetalworksRegistrator.ENTITY_MELTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MetalworksRegistrator.ENTITY_MELTING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<EntityMeltingRecipe> {
        private static final MapCodec<EntityMeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(recipe -> recipe.entity), (App)FluidStack.CODEC.listOf().fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, EntityMeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EntityMeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<EntityMeltingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EntityMeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static EntityMeltingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new EntityMeltingRecipe((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer), (List)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, EntityMeltingRecipe recipe) {
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.entity);
            FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.result);
        }
    }
}

