/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivemetalworks.Config;
import cy.jdkdigital.productivemetalworks.recipe.BlockCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import cy.jdkdigital.productivemetalworks.util.RecipeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;
import org.jetbrains.annotations.NotNull;

public class CastingBlockEntity
extends CapabilityBlockEntity {
    public int coolingTime = 0;
    public int maxAmount = 1000;
    public ItemStackHandler castInv = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            Level level = CastingBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CastingBlockEntity.this.sync(serverLevel);
            }
            CastingBlockEntity.this.setChanged();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    ItemStackHandler itemHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CastingBlockEntity.this.isCooling()) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            Level level = CastingBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CastingBlockEntity.this.sync(serverLevel);
            }
            CastingBlockEntity.this.setChanged();
        }
    };
    FluidTank fluidHandler = new FluidTank(1000){

        public boolean isFluidValid(FluidStack stack) {
            if (CastingBlockEntity.this.level == null || CastingBlockEntity.this.isCooling()) {
                return false;
            }
            if (CastingBlockEntity.this.castInv.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM) != null) {
                return true;
            }
            ItemCastingRecipe recipe = CastingBlockEntity.this.findRecipe(CastingBlockEntity.this.level, CastingBlockEntity.this.castInv.getStackInSlot(0), stack);
            return recipe != null && this.getFluidAmount() < recipe.getFluidAmount(CastingBlockEntity.this.level, stack) && CastingBlockEntity.this.getItemHandler().getStackInSlot(0).isEmpty();
        }

        public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !this.isFluidValid(resource) || CastingBlockEntity.this.level == null) {
                return 0;
            }
            ItemCastingRecipe recipe = CastingBlockEntity.this.findRecipe(CastingBlockEntity.this.level, CastingBlockEntity.this.castInv.getStackInSlot(0), resource);
            if (recipe == null) {
                return 0;
            }
            if (action.simulate()) {
                if (this.fluid.isEmpty()) {
                    return Math.min(recipe.getFluidAmount(CastingBlockEntity.this.level, resource), resource.getAmount());
                }
                if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
                    return 0;
                }
                return Math.min(recipe.getFluidAmount(CastingBlockEntity.this.level, resource) - this.fluid.getAmount(), resource.getAmount());
            }
            CastingBlockEntity.this.maxAmount = recipe.getFluidAmount(CastingBlockEntity.this.level, this.fluid);
            if (this.fluid.isEmpty()) {
                this.fluid = resource.copyWithAmount(Math.min(recipe.getFluidAmount(CastingBlockEntity.this.level, resource), resource.getAmount()));
                this.onContentsChanged();
                return this.fluid.getAmount();
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
                return 0;
            }
            int filled = recipe.getFluidAmount(CastingBlockEntity.this.level, resource) - this.fluid.getAmount();
            if (resource.getAmount() < filled) {
                this.fluid.grow(resource.getAmount());
                filled = resource.getAmount();
            } else {
                this.fluid.setAmount(recipe.getFluidAmount(CastingBlockEntity.this.level, resource));
            }
            if (filled > 0) {
                this.onContentsChanged();
            }
            return filled;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (CastingBlockEntity.this.isCooling()) {
                return FluidStack.EMPTY;
            }
            return super.drain(maxDrain, action);
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (CastingBlockEntity.this.isCooling()) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        protected void onContentsChanged() {
            Level level = CastingBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CastingBlockEntity.this.sync(serverLevel);
            }
            CastingBlockEntity.this.setChanged();
        }
    };

    public CastingBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)MetalworksRegistrator.CASTING_BLOCK_ENTITY.get(), pos, blockState);
    }

    public boolean isCooling() {
        return this.coolingTime > 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CastingBlockEntity castingTableBlock) {
        if (level instanceof ServerLevel) {
            FluidStack fluid;
            ServerLevel serverLevel = (ServerLevel)level;
            if (castingTableBlock.isCooling()) {
                --castingTableBlock.coolingTime;
                if (castingTableBlock.coolingTime == 0) {
                    fluid = castingTableBlock.getFluidHandler().getFluid();
                    ItemCastingRecipe recipe = castingTableBlock.findRecipe(level, castingTableBlock.castInv.getStackInSlot(0), fluid);
                    if (recipe != null && fluid.getAmount() >= recipe.getFluidAmount(level, fluid)) {
                        fluid.shrink(recipe.getFluidAmount(level, fluid));
                        if (recipe.consumeCast) {
                            if (recipe.result.is(ModTags.Items.CASTS)) {
                                castingTableBlock.castInv.setStackInSlot(0, recipe.result.copy());
                                castingTableBlock.getItemHandler().getStackInSlot(0).shrink(1);
                            } else {
                                castingTableBlock.castInv.setStackInSlot(0, ItemStack.EMPTY);
                            }
                        }
                        castingTableBlock.sync(serverLevel);
                        level.playSound(null, blockPos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, (float)level.random.nextInt(50, 100) / 100.0f, (float)level.random.nextInt(80, 100) / 100.0f);
                    }
                }
            }
            if (castingTableBlock.coolingTime == 0 && castingTableBlock.getItemHandler().getStackInSlot(0).isEmpty() && castingTableBlock.getFluidHandler().getFluidAmount() > 0) {
                ItemCastingRecipe recipe;
                FluidActionResult fillResult;
                fluid = castingTableBlock.getFluidHandler().getFluid();
                boolean hasFilledContainer = false;
                ItemStack cast = castingTableBlock.castInv.getStackInSlot(0);
                if (cast.is(Items.BUCKET) && (fillResult = FluidUtil.tryFillContainer((ItemStack)cast, (IFluidHandler)castingTableBlock.getFluidHandler(), (int)fluid.getAmount(), null, (boolean)true)).isSuccess()) {
                    castingTableBlock.itemHandler.setStackInSlot(0, fillResult.getResult());
                    castingTableBlock.castInv.setStackInSlot(0, ItemStack.EMPTY);
                    castingTableBlock.sync(serverLevel);
                    hasFilledContainer = true;
                }
                if (!hasFilledContainer && (recipe = castingTableBlock.findRecipe(level, cast, fluid)) != null && fluid.getAmount() >= recipe.getFluidAmount(level, fluid)) {
                    ItemStack resultItem = recipe.getResultItem(level, fluid);
                    castingTableBlock.itemHandler.setStackInSlot(0, resultItem);
                    castingTableBlock.coolingTime = Math.max(1, (int)((double)recipe.getFluidAmount(level, fluid) / Config.foundryCoolingModifier));
                    castingTableBlock.maxAmount = recipe.getFluidAmount(level, fluid);
                    castingTableBlock.sync(serverLevel);
                }
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, CastingBlockEntity castingTableBlock) {
        if (castingTableBlock.isCooling()) {
            --castingTableBlock.coolingTime;
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.put("cast", (Tag)this.castInv.serializeNBT(provider));
        tag.putInt("maxAmount", this.maxAmount);
        tag.putInt("coolingTime", this.coolingTime);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("cast")) {
            this.castInv.deserializeNBT(provider, tag.getCompound("cast"));
        }
        if (tag.contains("coolingTime")) {
            this.coolingTime = tag.getInt("coolingTime");
        }
        if (tag.contains("maxAmount")) {
            this.maxAmount = tag.getInt("maxAmount");
        }
    }

    public boolean canAcceptCast() {
        return this.getItemHandler().getStackInSlot(0).isEmpty() && this.castInv.getStackInSlot(0).isEmpty() && this.getFluidHandler().getFluidAmount() == 0;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    public void sync(ServerLevel serverLevel) {
        this.invalidateCapabilities();
        serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    private ItemCastingRecipe findRecipe(Level level, ItemStack cast, FluidStack fluid) {
        RecipeHolder<ItemCastingRecipe> recipe;
        BlockItem block;
        Waxable waxData;
        Item item;
        boolean isTable = this.getBlockState().is((Block)MetalworksRegistrator.CASTING_TABLE.get());
        if (isTable && cast.is(Items.BUCKET)) {
            return new ItemCastingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{cast}), new SizedFluidIngredient(FluidIngredient.single((FluidStack)fluid), 1000), FluidUtil.getFilledBucket((FluidStack)fluid), true);
        }
        if (!isTable && fluid.is((Fluid)MetalworksRegistrator.MOLTEN_WAX.get()) && (item = cast.getItem()) instanceof BlockItem && (waxData = (Waxable)(block = (BlockItem)item).getBlock().builtInRegistryHolder().getData(NeoForgeDataMaps.WAXABLES)) != null) {
            return new BlockCastingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{cast}), new SizedFluidIngredient(FluidIngredient.single((FluidStack)fluid), 50), waxData.waxed().asItem().getDefaultInstance(), true);
        }
        ItemCastingRecipe compatRecipe = RecipeHelper.getCompatRecipe(level, cast, fluid, isTable);
        if (compatRecipe != null) {
            return compatRecipe;
        }
        if (isTable) {
            recipe = RecipeHelper.getItemCastingRecipe(level, cast, fluid);
            return recipe == null ? null : (ItemCastingRecipe)recipe.value();
        }
        recipe = RecipeHelper.getBlockCastingRecipe(level, cast, fluid);
        return recipe == null ? null : (ItemCastingRecipe)recipe.value();
    }
}

