/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivelib.common.block.CapabilityContainerBlock;
import cy.jdkdigital.productivelib.common.block.IMultiBlockController;
import cy.jdkdigital.productivelib.exception.InvalidStructureException;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivemetalworks.Config;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FoundryControllerBlock
extends CapabilityContainerBlock
implements IMultiBlockController {
    public static final MapCodec<FoundryControllerBlock> CODEC = FoundryControllerBlock.simpleCodec(FoundryControllerBlock::new);

    public FoundryControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.ATTACHED}).add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FoundryControllerBlockEntity(blockPos, blockState);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof FoundryControllerBlockEntity) {
            FoundryControllerBlockEntity blockEntity2 = (FoundryControllerBlockEntity)blockEntity;
            try {
                blockEntity2.setMultiBlockData(FoundryControllerBlock.detectMultiblock((Level)serverLevel, pos));
            }
            catch (InvalidStructureException invalidStructureException) {
                // empty catch block
            }
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return FoundryControllerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.isClientSide ? FoundryControllerBlockEntity::clientTick : FoundryControllerBlockEntity::serverTick));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        block4: {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FoundryControllerBlockEntity) {
                FoundryControllerBlockEntity blockEntity2 = (FoundryControllerBlockEntity)blockEntity;
                try {
                    blockEntity2.setMultiBlockData(FoundryControllerBlock.detectMultiblock(level, pos));
                    if (!level.isClientSide) {
                        player.openMenu((MenuProvider)blockEntity2, pos);
                    }
                }
                catch (InvalidStructureException ise) {
                    if (level.isClientSide) break block4;
                    player.sendSystemMessage((Component)Component.translatable((String)"productivemetalworks.message.foundry_invalid", (Object[])new Object[]{ise.getMessage(), String.valueOf(level.getBlockState(ise.getPos()))}));
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (oldState.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FoundryControllerBlockEntity) {
            FoundryControllerBlockEntity blockEntity2 = (FoundryControllerBlockEntity)blockEntity;
            for (int slot = 0; slot < blockEntity2.getItemHandler().getSlots(); ++slot) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)blockEntity2.getItemHandler().getStackInSlot(slot));
            }
            MultiBlockDetector.MultiBlockData mb = blockEntity2.getMultiblockData();
            if (mb != null) {
                Direction controllerFacing = (Direction)oldState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockPos.betweenClosedStream((BlockPos)((BlockPos)mb.topCorners().getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()).below(mb.height()), (BlockPos)((BlockPos)mb.topCorners().getSecond()).relative(controllerFacing).relative(controllerFacing.getClockWise()).below(mb.height())).forEach(blockPos -> {
                    BlockState state = level.getBlockState(blockPos);
                    if (state.hasProperty((Property)BlockStateProperties.ATTACHED)) {
                        level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
                    }
                });
            }
        }
        super.onRemove(oldState, level, pos, newState, isMoving);
    }

    public static MultiBlockDetector.MultiBlockData detectMultiblock(Level level, BlockPos pos) throws InvalidStructureException {
        return MultiBlockDetector.detectStructure((Level)level, (BlockPos)pos, ModTags.Blocks.FOUNDRY_WALL_BLOCKS, ModTags.Blocks.FOUNDRY_BOTTOM_BLOCKS, (boolean)true, (boolean)true, (boolean)true, (int)Config.foundryMaxVolume, (int)Config.foundryMaxCircumference, (int)Config.foundryMaxHeight);
    }
}

