/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryCapacitorBlockEntity;
import cy.jdkdigital.productivemetalworks.util.RenderHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FoundryCapacitorBlockEntityRenderer
implements BlockEntityRenderer<FoundryCapacitorBlockEntity> {
    static ResourceLocation POWER = ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/power_level");

    public FoundryCapacitorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FoundryCapacitorBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (blockEntity.getLevel() != null && blockEntity.getEnergyHandler().getMaxEnergyStored() > 0) {
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            float f = 12.0f - 12.0f * (float)blockEntity.getEnergyHandler().getEnergyStored() / (float)blockEntity.getEnergyHandler().getMaxEnergyStored();
            poseStack.pushPose();
            VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.cutout());
            RenderHelper.renderCenteredTexturedSide(poseStack, vertexBuffer, facing, POWER, 6.0f, 1.99f * RenderHelper.pixelFraction, (14.0f - f) * RenderHelper.pixelFraction, combinedLightIn, combinedOverlayIn);
            poseStack.popPose();
        }
    }
}

