/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.upgrade;

import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.setup.Config;
import com.direwolf20.mininggadgets.setup.Registration;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum Upgrade {
    EMPTY("empty", Registration.UPGRADE_EMPTY, () -> 0, false),
    SILK("silk", Registration.SILK, () -> (Integer)Config.UPGRADECOST_SILKTOUCH.get(), true),
    VOID_JUNK("void_junk", Registration.VOID_JUNK, () -> (Integer)Config.UPGRADECOST_VOID.get()),
    MAGNET("magnet", Registration.MAGNET, () -> (Integer)Config.UPGRADECOST_MAGNET.get()),
    FREEZING("freezing", Registration.FREEZING, () -> 0),
    LIGHT_PLACER("light_placer", Registration.LIGHT_PLACER, () -> 0),
    SIZE_1("size_1", Registration.SIZE_1, 1, () -> 0),
    SIZE_2("size_2", Registration.SIZE_2, 2, () -> 0),
    SIZE_3("size_3", Registration.SIZE_3, 3, () -> 0),
    FORTUNE_1("fortune_1", Registration.FORTUNE_1, 1, () -> (Integer)Config.UPGRADECOST_FORTUNE1.get(), true),
    FORTUNE_2("fortune_2", Registration.FORTUNE_2, 2, () -> (Integer)Config.UPGRADECOST_FORTUNE2.get(), true),
    FORTUNE_3("fortune_3", Registration.FORTUNE_3, 3, () -> (Integer)Config.UPGRADECOST_FORTUNE3.get(), true),
    BATTERY_1("battery_1", Registration.BATTERY_1, 1, () -> 0),
    BATTERY_2("battery_2", Registration.BATTERY_2, 2, () -> 0),
    BATTERY_3("battery_3", Registration.BATTERY_3, 3, () -> 0),
    BATTERY_CREATIVE("battery_creative", Registration.BATTERY_CREATIVE, 4, () -> 0),
    RANGE_1("range_1", Registration.RANGE_1, 1, () -> 0),
    RANGE_2("range_2", Registration.RANGE_2, 2, () -> 0),
    RANGE_3("range_3", Registration.RANGE_3, 3, () -> 0),
    EFFICIENCY_1("efficiency_1", Registration.EFFICIENCY_1, 1, () -> (Integer)Config.UPGRADECOST_EFFICIENCY1.get(), true),
    EFFICIENCY_2("efficiency_2", Registration.EFFICIENCY_2, 2, () -> (Integer)Config.UPGRADECOST_EFFICIENCY2.get(), true),
    EFFICIENCY_3("efficiency_3", Registration.EFFICIENCY_3, 3, () -> (Integer)Config.UPGRADECOST_EFFICIENCY3.get(), true),
    EFFICIENCY_4("efficiency_4", Registration.EFFICIENCY_4, 4, () -> (Integer)Config.UPGRADECOST_EFFICIENCY4.get(), true),
    EFFICIENCY_5("efficiency_5", Registration.EFFICIENCY_5, 5, () -> (Integer)Config.UPGRADECOST_EFFICIENCY5.get(), true);

    private final String name;
    private final String baseName;
    private final DeferredHolder<Item, UpgradeCard> card;
    private final int tier;
    private final Supplier<Integer> costPerBlock;
    private boolean active = true;
    private final boolean isToggleable;
    private final String toolTip;

    private Upgrade(String name, DeferredHolder<Item, UpgradeCard> itemCard, int tier, Supplier<Integer> costPerBlock, boolean isToggleable) {
        this.name = name;
        this.tier = tier;
        this.costPerBlock = costPerBlock;
        this.card = itemCard;
        this.baseName = tier == -1 ? name : name.substring(0, name.lastIndexOf(95));
        this.isToggleable = isToggleable;
        this.toolTip = "tooltop.mininggadgets." + this.baseName;
    }

    private Upgrade(String name, DeferredHolder<Item, UpgradeCard> itemCard, int tier, Supplier<Integer> costPerBlock) {
        this(name, itemCard, tier, costPerBlock, false);
    }

    private Upgrade(String name, DeferredHolder<Item, UpgradeCard> itemCard, Supplier<Integer> costPerBlock) {
        this(name, itemCard, -1, costPerBlock, true);
    }

    private Upgrade(String name, DeferredHolder<Item, UpgradeCard> itemCard, Supplier<Integer> costPerBlock, boolean isToggleable) {
        this(name, itemCard, -1, costPerBlock, isToggleable);
    }

    public String getName() {
        return this.name;
    }

    public DeferredHolder<Item, UpgradeCard> getCardItem() {
        return this.card;
    }

    public int getTier() {
        return this.tier;
    }

    public int getCostPerBlock() {
        return this.costPerBlock.get();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getLocal() {
        return String.format("item.mininggadgets.upgrade_%s", this.getName());
    }

    public String getLocalReplacement() {
        return "mininggadgets.upgrade.replacement";
    }

    public boolean hasTier() {
        return this.tier != -1;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean active) {
        this.active = active;
    }

    public boolean isToggleable() {
        return this.isToggleable;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean lazyIs(Upgrade upgrade) {
        return this.getBaseName().equals(upgrade.getBaseName());
    }
}

