/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.capabilities.EnergyStorageItemstack;
import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeBatteryLevels;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ModificationTableCommands {
    public static boolean insertButton(ModificationTableContainer container, ItemStack upgrade) {
        Slot laserSlot = (Slot)container.slots.get(0);
        ItemStack laser = laserSlot.getItem();
        if (laser.getItem() instanceof MiningGadget && upgrade.getItem() instanceof UpgradeCard) {
            Upgrade card = ((UpgradeCard)upgrade.getItem()).getUpgrade();
            if (card == Upgrade.EMPTY) {
                return false;
            }
            List<Upgrade> upgrades = UpgradeTools.getUpgrades(laser);
            boolean hasFortune = UpgradeTools.containsUpgradeFromList(upgrades, Upgrade.FORTUNE_1);
            boolean hasSilk = UpgradeTools.containsUpgradeFromList(upgrades, Upgrade.SILK);
            if (UpgradeTools.containsUpgrade(laser, card)) {
                return false;
            }
            if (card.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
            }
            if (card.getBaseName().equals(Upgrade.SIZE_1.getBaseName())) {
                MiningProperties.setRange(laser, UpgradeTools.getMaxMiningRange(card.getTier()));
                MiningProperties.setMaxMiningRange(laser, UpgradeTools.getMaxMiningRange(card.getTier()));
            }
            if (hasFortune && card.getBaseName().equals(Upgrade.SILK.getBaseName()) || hasSilk && card.getBaseName().equals(Upgrade.FORTUNE_1.getBaseName())) {
                ((UpgradeCard)upgrade.getItem()).getUpgrade().setEnabled(false);
            }
            MiningGadget.applyUpgrade(laser, (UpgradeCard)upgrade.getItem());
            if (card.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                UpgradeBatteryLevels.getBatteryByLevel(card.getTier()).ifPresent(power -> {
                    IEnergyStorage cap = (IEnergyStorage)laser.getCapability(Capabilities.EnergyStorage.ITEM);
                    if (cap == null) {
                        return;
                    }
                    ((EnergyStorageItemstack)cap).updatedMaxEnergy(power.getPower());
                    if (card.getTier() == Upgrade.BATTERY_CREATIVE.getTier()) {
                        cap.receiveEnergy(cap.getMaxEnergyStored() - cap.getEnergyStored(), false);
                    }
                });
                MiningProperties.setBatteryTier(laser, card.getTier());
            }
            return true;
        }
        return false;
    }

    public static void extractButton(ModificationTableContainer container, ServerPlayer player, String upgradeName) {
        Slot laserSlot = (Slot)container.slots.get(0);
        ItemStack laser = laserSlot.getItem();
        if (!(laser.getItem() instanceof MiningGadget)) {
            return;
        }
        if (!UpgradeTools.containsUpgrades(laser)) {
            return;
        }
        UpgradeTools.getUpgrades(laser).forEach(upgrade -> {
            if (!upgrade.getName().equals(upgradeName)) {
                return;
            }
            UpgradeTools.removeUpgrade(laser, upgrade);
            boolean success = player.getInventory().add(new ItemStack((ItemLike)upgrade.getCardItem().get(), 1));
            if (!success) {
                player.drop(new ItemStack((ItemLike)upgrade.getCardItem().get(), 1), true);
            }
            if (upgrade.getBaseName().equals(Upgrade.SIZE_1.getBaseName())) {
                MiningProperties.setRange(laser, 1);
                MiningProperties.setMaxMiningRange(laser, 1);
            }
            if (upgrade.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, 5);
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(0));
            }
            if (upgrade.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                MiningProperties.setBatteryTier(laser, 0);
                IEnergyStorage cap = (IEnergyStorage)laser.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cap == null) {
                    return;
                }
                ((EnergyStorageItemstack)cap).updatedMaxEnergy(UpgradeBatteryLevels.BATTERY.getPower());
            }
        });
    }
}

