/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.client.screens.widget.ToggleButton;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.data.ChangeFreezeDelayPayload;
import com.direwolf20.mininggadgets.common.network.data.ChangeMiningSizeModePayload;
import com.direwolf20.mininggadgets.common.network.data.ChangeMiningSizePayload;
import com.direwolf20.mininggadgets.common.network.data.ChangeRangePayload;
import com.direwolf20.mininggadgets.common.network.data.ChangeVolumePayload;
import com.direwolf20.mininggadgets.common.network.data.OpenFilterContainerPayload;
import com.direwolf20.mininggadgets.common.network.data.ToggleFiltersPayload;
import com.direwolf20.mininggadgets.common.network.data.TogglePrecisionPayload;
import com.direwolf20.mininggadgets.common.network.data.UpdateUpgradePayload;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class MiningSettingScreen
extends Screen {
    private ItemStack gadget;
    private int beamRange;
    private int freezeDelay;
    private float volume;
    private int currentSize = 1;
    private boolean isWhitelist = true;
    private boolean isPrecision = true;
    private ExtendedSlider rangeSlider;
    private ExtendedSlider volumeSlider;
    private ExtendedSlider freezeDelaySlider;
    private List<Upgrade> toggleableList = new ArrayList<Upgrade>();
    private HashMap<Upgrade, ToggleButton> upgradeButtons = new HashMap();
    private boolean containsFreeze = false;
    private MiningProperties.SizeMode currentMode;

    public MiningSettingScreen(ItemStack gadget) {
        super((Component)Component.literal((String)"title"));
        this.gadget = gadget;
        this.beamRange = MiningProperties.getBeamRange(gadget);
        this.volume = MiningProperties.getVolume(gadget);
        this.freezeDelay = MiningProperties.getFreezeDelay(gadget);
        this.currentMode = MiningProperties.getSizeMode(gadget);
    }

    protected void init() {
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        int baseX = this.width / 2;
        int baseY = this.height / 2;
        this.toggleableList.clear();
        this.toggleableList = UpgradeTools.getUpgrades(this.gadget).stream().filter(Upgrade::isToggleable).collect(Collectors.toList());
        this.containsFreeze = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.FREEZING);
        boolean containsVoid = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.VOID_JUNK);
        this.isWhitelist = MiningProperties.getWhiteList(this.gadget);
        this.isPrecision = MiningProperties.getPrecisionMode(this.gadget);
        int top = baseY - (this.containsFreeze ? 80 : 60);
        int index = 0;
        int x = baseX + 10;
        int y = top + (containsVoid ? 45 : 20);
        for (Upgrade upgrade : this.toggleableList) {
            ToggleButton btn = new ToggleButton(x + index * 30, y, UpgradeTools.getName(upgrade), ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)("textures/item/upgrade_" + upgrade.getName() + ".png")), send -> this.toggleUpgrade(upgrade, (boolean)send));
            this.addRenderableWidget((GuiEventListener)btn);
            this.upgradeButtons.put(upgrade, btn);
            if (++index % 4 != 0) continue;
            index = 0;
            y += 35;
        }
        if (containsVoid) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)MiningSettingScreen.getTrans("tooltip.screen.edit_filters", new Object[0]), button -> PacketDistributor.sendToServer((CustomPacketPayload)new OpenFilterContainerPayload(), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(baseX + 10, top + 20).size(95, 20).build());
            this.addRenderableWidget((GuiEventListener)new WhitelistButton(baseX + 10 + 95, top + 20, 20, 20, this.isWhitelist, button -> {
                this.isWhitelist = !this.isWhitelist;
                ((WhitelistButton)button).setWhitelist(this.isWhitelist);
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleFiltersPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }));
        }
        this.currentSize = MiningProperties.getRange(this.gadget);
        int maxMiningRange = MiningProperties.getMaxMiningRange(this.gadget);
        Button sizeButton = Button.builder((Component)MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize), button -> {
            this.currentSize = this.currentSize == maxMiningRange ? 1 : (this.currentSize += 2);
            button.setMessage((Component)MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize));
            PacketDistributor.sendToServer((CustomPacketPayload)new ChangeMiningSizePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(baseX - 135, 0).size(125, 20).build();
        leftWidgets.add(sizeButton);
        if (maxMiningRange > 3) {
            leftWidgets.add(Button.builder((Component)this.currentMode.getTooltip(), button -> {
                this.currentMode = MiningProperties.nextSizeMode(this.gadget);
                button.setMessage(this.currentMode.getTooltip());
                PacketDistributor.sendToServer((CustomPacketPayload)new ChangeMiningSizeModePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }).pos(baseX - 135, 0).size(125, 20).build());
        }
        this.rangeSlider = new ExtendedSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.range", new Object[0]).append(": "), (Component)Component.empty(), 1.0, MiningProperties.getBeamMaxRange(this.gadget), this.beamRange, true){

            protected void applyValue() {
                MiningSettingScreen.this.beamRange = this.getValueInt();
            }
        };
        leftWidgets.add(this.rangeSlider);
        leftWidgets.add(Button.builder((Component)MiningSettingScreen.getTrans("tooltip.screen.visuals_menu", new Object[0]), button -> ModScreens.openVisualSettingsScreen(this.gadget)).pos(baseX - 135, 0).size(125, 20).build());
        leftWidgets.add(Button.builder((Component)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision), button -> {
            this.isPrecision = !this.isPrecision;
            button.setMessage((Component)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision));
            PacketDistributor.sendToServer((CustomPacketPayload)new TogglePrecisionPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(baseX - 135, 0).size(125, 20).build());
        this.volumeSlider = new ExtendedSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.volume", new Object[0]).append(": "), (Component)Component.literal((String)"%"), 0.0, 100.0, this.volume * 100.0f, true){

            protected void applyValue() {
                MiningSettingScreen.this.volume = (float)(this.getValue() / 100.0);
            }
        };
        leftWidgets.add(this.volumeSlider);
        if (this.containsFreeze) {
            this.freezeDelaySlider = new ExtendedSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.freeze_delay", new Object[0]).append(": "), (Component)Component.literal((String)" ").append((Component)MiningSettingScreen.getTrans("tooltip.screen.ticks", new Object[0])), 0.0, 10.0, MiningProperties.getFreezeDelay(this.gadget), true){

                protected void applyValue() {
                    MiningSettingScreen.this.freezeDelay = this.getValueInt();
                }
            };
            leftWidgets.add(this.freezeDelaySlider);
        }
        if (maxMiningRange == 1) {
            sizeButton.active = false;
        }
        for (int i = 0; i < leftWidgets.size(); ++i) {
            ((AbstractWidget)leftWidgets.get(i)).setY(top + 20 + i * 25);
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    private boolean toggleUpgrade(Upgrade upgrade, boolean update) {
        if (update) {
            this.updateButtons(upgrade);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateUpgradePayload(upgrade.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return upgrade.isEnabled();
    }

    private void updateButtons(Upgrade upgrade) {
        for (Map.Entry<Upgrade, ToggleButton> btn : this.upgradeButtons.entrySet()) {
            Upgrade btnUpgrade = btn.getKey();
            if ((!btnUpgrade.lazyIs(Upgrade.FORTUNE_1) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.SILK)) && (!btnUpgrade.lazyIs(Upgrade.SILK) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.FORTUNE_1))) continue;
            this.upgradeButtons.get((Object)btn.getKey()).setEnabled(false);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int top = this.height / 2 - (this.containsFreeze ? 80 : 60);
        guiGraphics.drawString(this.font, (Component)MiningSettingScreen.getTrans("tooltip.screen.mining_gadget", new Object[0]), this.width / 2 - 135, top, Color.WHITE.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)MiningSettingScreen.getTrans("tooltip.screen.toggle_upgrades", new Object[0]), this.width / 2 + 10, top, Color.WHITE.getRGB(), false);
        if (this.toggleableList.size() == 0) {
            guiGraphics.drawString(this.font, (Component)MiningSettingScreen.getTrans("tooltip.screen.no_upgrades", new Object[0]), this.width / 2 + 10, top + 20, Color.GRAY.getRGB(), false);
        }
        this.children().forEach(e -> {
            if (!(e instanceof ToggleButton || e instanceof WhitelistButton || e.equals((Object)this.freezeDelaySlider))) {
                return;
            }
            if (e instanceof WhitelistButton) {
                if (e.isMouseOver((double)mouseX, (double)mouseY)) {
                    guiGraphics.renderTooltip(this.font, (Component)(this.isWhitelist ? MiningSettingScreen.getTrans("tooltip.screen.whitelist", new Object[0]) : MiningSettingScreen.getTrans("tooltip.screen.blacklist", new Object[0])), mouseX, mouseY);
                }
            } else if (e.equals((Object)this.freezeDelaySlider)) {
                if (e.isMouseOver((double)mouseX, (double)mouseY)) {
                    assert (e instanceof ExtendedSlider);
                    List helpText = Arrays.stream(MiningSettingScreen.getTrans("tooltip.screen.delay_explain", new Object[0]).getString().split("\n")).map(Component::literal).collect(Collectors.toList());
                    guiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(helpText), ((ExtendedSlider)e).getX() - 8, ((ExtendedSlider)e).getY() + 40);
                }
            } else {
                assert (e instanceof ToggleButton);
                ToggleButton btn = (ToggleButton)((Object)e);
                if (btn.isMouseOver(mouseX, mouseY)) {
                    guiGraphics.renderTooltip(this.font, btn.getOurTooltip(), DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
                }
            }
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeRangePayload(this.beamRange), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeVolumePayload(this.volume), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeFreezeDelayPayload(this.freezeDelay), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.removed();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("mininggadgets." + key), (Object[])args);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        if (this.rangeSlider.isMouseOver(mouseX, mouseY)) {
            this.rangeSlider.setValue((double)(this.rangeSlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.beamRange = this.rangeSlider.getValueInt();
        }
        if (this.freezeDelaySlider != null && this.freezeDelaySlider.isMouseOver(mouseX, mouseY)) {
            this.freezeDelaySlider.setValue((double)(this.freezeDelaySlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.freezeDelay = this.freezeDelaySlider.getValueInt();
        }
        if (this.volumeSlider.isMouseOver(mouseX, mouseY)) {
            this.volumeSlider.setValue((double)(this.volumeSlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.volume = this.volumeSlider.getValueInt();
        }
        return false;
    }

    public static final class WhitelistButton
    extends Button {
        private boolean isWhitelist;

        public WhitelistButton(int widthIn, int heightIn, int width, int height, boolean isWhitelist, Button.OnPress onPress) {
            super(Button.builder((Component)Component.empty(), (Button.OnPress)onPress).pos(widthIn, heightIn).size(width, height));
            this.isWhitelist = isWhitelist;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + this.width - 2, this.getY() + this.height - 2, this.isWhitelist ? -1 : -16777216);
        }

        public void setWhitelist(boolean whitelist) {
            this.isWhitelist = whitelist;
        }
    }
}

