/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import com.direwolf20.mininggadgets.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class ModificationShiftOverlay {
    public static void render(RenderLevelStageEvent evt, Player player) {
        HitResult pick = player.pick(5.0, 0.0f, false);
        if (pick.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult trace = (BlockHitResult)pick;
        if (player.level().getBlockState(trace.getBlockPos()).getBlock() != Registration.MODIFICATION_TABLE.get()) {
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(trace.getBlockPos());
        if (!(blockEntity instanceof ModificationTableTileEntity)) {
            return;
        }
        ItemStack stack = ((ModificationTableTileEntity)blockEntity).handler.getStackInSlot(0);
        if (stack.isEmpty() || !(stack.getItem() instanceof MiningGadget)) {
            return;
        }
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        if (upgrades.isEmpty()) {
            return;
        }
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        BlockPos blockPos = ((BlockHitResult)pick).getBlockPos();
        double distance = player.getPosition(evt.getPartialTick().getRealtimeDeltaTicks()).distanceTo(new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()));
        float scaleFactor = Math.max(0.2f, (float)distance / 10.0f + 0.1f);
        PoseStack matrix = evt.getPoseStack();
        matrix.pushPose();
        matrix.translate(-view.x, -view.y, -view.z);
        matrix.translate((float)blockPos.getX() + 0.5f, (float)(blockPos.getY() + 1), (float)blockPos.getZ() + 0.5f);
        matrix.scale(scaleFactor, scaleFactor, scaleFactor);
        matrix.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        MultiBufferSource.BufferSource outlineLayerBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
        int x = 0;
        int y = 0;
        float offset = upgrades.size() / 3 > 0 ? -1.15f : (upgrades.size() > 1 ? -((float)upgrades.size() / 3.0f) : -0.2f);
        for (Upgrade upgrade : upgrades) {
            matrix.pushPose();
            matrix.translate(offset + (float)x, (float)y, 0.0f);
            matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(26.0f));
            ItemStack upgradeStack = new ItemStack((ItemLike)upgrade.getCardItem().get());
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(upgradeStack, (Level)Minecraft.getInstance().level, null, 0);
            Minecraft.getInstance().getItemRenderer().render(upgradeStack, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, false, matrix, (MultiBufferSource)outlineLayerBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            if (++x > 2) {
                x = 0;
                ++y;
            }
            matrix.popPose();
        }
        outlineLayerBuffer.endBatch();
        matrix.popPose();
    }
}

