/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPredicates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PieceOriginAxisAlignedLinearPosRuleTest
extends PosRuleTest {
    public static final MapCodec<PieceOriginAxisAlignedLinearPosRuleTest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.minDistance), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.maxDistance), (App)Direction.Axis.CODEC.fieldOf("axis").orElse((Object)Direction.Axis.Y).forGetter(ruleTest -> ruleTest.axis)).apply((Applicative)instance, PieceOriginAxisAlignedLinearPosRuleTest::new));
    private final float minChance;
    private final float maxChance;
    private final int minDistance;
    private final int maxDistance;
    private final Direction.Axis axis;

    public PieceOriginAxisAlignedLinearPosRuleTest(float minChance, float maxChance, int minDistance, int maxDistance, Direction.Axis axis) {
        if (minDistance >= maxDistance) {
            throw new IllegalArgumentException("Invalid range: [" + minDistance + "," + maxDistance + "]");
        }
        this.minChance = minChance;
        this.maxChance = maxChance;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.axis = axis;
    }

    public boolean test(BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, RandomSource random) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis);
        float xDist = Math.abs(blockPos.getX() * direction.getStepX());
        float yDist = Math.abs(blockPos.getY() * direction.getStepY());
        float zDist = Math.abs(blockPos.getZ() * direction.getStepZ());
        int distanceFromOrigin = (int)(xDist + yDist + zDist);
        float randomChance = random.nextFloat();
        return (double)randomChance <= (double)Mth.clampedLerp((float)this.minChance, (float)this.maxChance, (float)Mth.inverseLerp((float)distanceFromOrigin, (float)this.minDistance, (float)this.maxDistance));
    }

    protected PosRuleTestType<?> getType() {
        return (PosRuleTestType)BzPredicates.PIECE_ORIGIN_AXIS_ALIGNED_LINEAR_POS_RULE_TEST.get();
    }
}

